/* 
 * process.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.8 $
 * $Date: 1992/02/12 01:44:10 $
 */

#ifndef process_h
#define process_h

/* sparc change: include light weight process structures */
#ifndef XKMACHKERNEL
#include <mach.h>
#include <cthreads.h>
#else
#include <kern/thread.h>
#endif XKMACHKERNEL
#include <mach/message.h>
/* define standard priority; higher numbers have less priority */
#define STD_PRIO	5
#define THREAD_MAXPRIO 31

#ifndef NULL
#define NULL 0
#endif

#if (defined(USE_GC))
#define malloc(X) gc_malloc(X)
#define free(X) gc_free(X)
#endif

#define CreateProcess0 CreateProcess
#define CreateProcess1 CreateProcess
#define CreateProcess2 CreateProcess
#define CreateProcess3 CreateProcess
#define CreateProcess4 CreateProcess
#define CreateProcess5 CreateProcess
#define CreateProcess6 CreateProcess
#define xCreateProcess CreateProcess


typedef struct {
#ifdef mips
  int x; /* not a $%#%@ idea, hope it isn't used... */
#endif
} jmp_buff; /* Had to rename because of Mach C compiler [mats] */

typedef struct _Process {
  jmp_buff		jb;
  long 			*stack, *stacklimit;
  short			prio;
  struct _Process *	link;
  int			index;
#ifdef MUTS
  void *muts;
#endif
#ifdef XKMACHKERNEL
  thread_t              thread;	/* mats */
#else
  cthread_t             thread;	/* mats */
#endif XKMACHKERNEL
} Process;

#define STACKSIZE (32*1024)

#ifdef XKMACHKERNEL
typedef struct sQueue {
	struct sQueue 	*head, **tail, *link;
	thread_t	thread;
} WaitingQueue;

typedef struct sSemaphore {
	int			count;
	WaitingQueue		waitQueue;
} Semaphore;

#define Q_INIT(Q) { \
  (Q)->head = NULL; \
  (Q)->tail = &(Q)->head; \
}

#define Q_EMPTY(Q) ((Q)->tail == &(Q)->head)

#define Q_INSERTLAST(Q, E) { \
  *((Q)->tail) = (E); \
  (E)->link = NULL; \
  (Q)->tail = &(E)->link; \
}

#define Q_INSERTFIRST(Q, E) { \
  (E)->link = (Q)->head; \
  (Q)->head = (E); \
  if (Q_EMPTY(Q)) (Q)->tail = &(E)->link; \
}

#define Q_REMOVEFIRST(Q, E) { \
  if ((E) = (Q)->head) { \
    if (! ((Q)->head = (E)->link)) (Q)->tail = &(Q)->head; \
  } \
}

#else

typedef struct sSemaphore {
	struct mutex		lock;
	struct condition	cond;
	int			count;
	int			sleepers;
} Semaphore;
#endif XKMACHKERNEL

#define semWait(S) { if (--(S)->count < 0) realP(S); }
#define semSignal(S) { if (++(S)->count <= 0) realV(S); }
#ifdef __STDC__
extern void semInit( Semaphore *, unsigned int );
extern void realP( Semaphore * );
extern void realV( Semaphore * );
#else
extern void semInit( );
extern void realP( );
extern void realV( );
#endif
extern Process *Active;
extern int	SignalsPossible;
#define kSwitch() Yield()
#endif
