/* 
 * xk_debug.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.19 $
 * $Date: 1992/02/06 19:08:31 $
 */

#ifndef xk_debug_h
#define xk_debug_h

#include "x_stdio.h"
#include "trace.h"

extern int
	tracebuserror,
	tracecustom,
  	traceethdrv,
#ifdef XKMACHKERNEL
 	tracelance,
#endif XKMACHKERNEL
 	traceether,
	traceevent,
	tracefixme,
	traceidle,
	traceie,
	traceinit,  
	tracememoryinit,
	tracemsg,  
	traceprocesscreation,
	traceprocessswitch,
	traceprotocol,
	traceptbl,
  	traceprottest,
	tracetick,
	tracetrap,
  	tracelock,
  	tracespl,
	tracesessngc,
	traceuser;

extern	char errBuf[];


#if !defined(NDEBUG) || defined(lint)

#define PRETRACE(l) { int i=l; while(i--) putchar(' '); }
#define POSTTRACE putchar('\n')

#ifdef __STDC__
#define XPASTE(X,Y) X##Y
#define PASTE(X,Y) XPASTE(X,Y)


#   define xIfTrace(t, l) \
	if (PASTE(trace,t) >= l)
#   define xTrace0(t, l, f) 		\
	{				\
	    if (PASTE(trace,t) >= l) {	\
		PRETRACE(l);		\
	    	printf(f); 		\
	    	POSTTRACE;		\
	    }				\
	}
#   define xTrace1(t, l, f, arg1) 	\
	{				\
	    if (PASTE(trace,t) >= l) {	\
		PRETRACE(l);		\
	    	printf(f, arg1);	\
	    	POSTTRACE;		\
	    }				\
	}
#   define xTrace2(t, l, f, arg1, arg2) \
	{				\
	    if (PASTE(trace,t) >= l) {	\
		PRETRACE(l);		\
	    	printf(f, arg1, arg2);	\
	    	POSTTRACE;		\
	    }				\
	}
#   define xTrace3(t, l, f, arg1, arg2, arg3) \
	{				\
	    if (PASTE(trace,t) >= l) {	\
		PRETRACE(l);		\
	    	printf(f, arg1, arg2, arg3);	\
	    	POSTTRACE;		\
	    }				\
	}
#   define xTrace4(t, l, f, arg1, arg2, arg3, arg4) \
	{				\
	    if (PASTE(trace,t) >= l) {	\
		PRETRACE(l);		\
	    	printf(f, arg1, arg2, arg3, arg4);	\
	    	POSTTRACE;		\
	    }				\
	}
#   define xTrace5(t, l, f, arg1, arg2, arg3, arg4, arg5) \
	{				\
	    if (PASTE(trace,t) >= l) {	\
		PRETRACE(l);		\
	    	printf(f, arg1, arg2, arg3, arg4, arg5); \
	    	POSTTRACE;		\
	    }				\
	}
#else
#define D___I(X) X


#   define xIfTrace(t, l) \
	if (D___I(trace)t >= l)
#   define xTrace0(t, l, f) 			\
	{					\
	    if (D___I(trace)t >= l) { 		\
	    	PRETRACE(l); 			\
	    	printf(f); 			\
	    	POSTTRACE; 			\
	    }					\
	}
#   define xTrace1(t, l, f, arg1) \
	{					\
	    if (D___I(trace)t >= l) { 		\
	    	PRETRACE(l); 			\
		printf(f, arg1); 		\
	    	POSTTRACE; 			\
	    }					\
	}
#   define xTrace2(t, l, f, arg1, arg2) \
	{					\
	    if (D___I(trace)t >= l) { 		\
	    	PRETRACE(l); 			\
	    	printf(f, arg1, arg2); 		\
	    	POSTTRACE; 			\
	    }					\
	}
#   define xTrace3(t, l, f, arg1, arg2, arg3) \
	{					\
	    if (D___I(trace)t >= l) { 		\
	    	PRETRACE(l); 			\
	    	printf(f, arg1, arg2, arg3); 	\
	    	POSTTRACE; 			\
	    }					\
	}
#   define xTrace4(t, l, f, arg1, arg2, arg3, arg4) \
	{					\
	    if (D___I(trace)t >= l) { 		\
	    	PRETRACE(l); 			\
	    	printf(f, arg1, arg2, arg3, arg4); \
	    	POSTTRACE; 			\
	    }					\
	}
#   define xTrace5(t, l, f, arg1, arg2, arg3, arg4, arg5) \
	{					\
	    if (D___I(trace)t >= l) { 		\
	    	PRETRACE(l); 			\
	    	printf(f, arg1, arg2, arg3, arg4, arg5); \
	    	POSTTRACE; 			\
	    }					\
	}

#endif /* __STDC__ */
#else

#   define xIfTrace(t, l) if (0)
#   define xTrace0(t, l, f)
#   define xTrace1(t, l, f, arg1)
#   define xTrace2(t, l, f, arg1, arg2)
#   define xTrace3(t, l, f, arg1, arg2, arg3)
#   define xTrace4(t, l, f, arg1, arg2, arg3, arg4)
#   define xTrace5(t, l, f, arg1, arg2, arg3, arg4, arg5)

#endif	/* ! NDEBUG */

extern void	xError(
#ifdef __STDC__
		       char *
#endif
		       );

#endif	/* xk_debug_h */
