functor LexToolDefFun (SMLTool :TOOL) :TOOLDEF = struct

val toolName = "lex"

val processor = ref "sml-lex"
val targetNamer = ref (fn (pathname:string) => (pathname ^ ".sml"))

fun runLex (sourceName:string) = 
  let val _ = (print "[starting sml-lex "; print sourceName; print "]\n")
      val callString = ((!processor)^" "^sourceName)
      val _ = (print ("[" ^ callString ^ "]\n"))
      val status = System.system callString
  in if (status = 0) then ()
       else raise SourceGroup.CompilingError;
   print "[ending   sml-lex "; print sourceName; print "]\n"
  end

fun fileExists filename =
  let val _ = System.Unsafe.SysIO.mtime (System.Unsafe.SysIO.PATH filename) in
    true
  end handle _ => false

fun loadSource (group:SourceGroup.group) (sourceName:string) (targetName:string) =
 (runLex sourceName;
  SMLTool.loadSource group targetName (SMLTool.targetNameOf targetName))

fun genTarget (group:SourceGroup.group) (sourceName:string) (targetName:string) =
 (runLex sourceName;
  SMLTool.genTarget group targetName (SMLTool.targetNameOf targetName))

fun loadTarget (group:SourceGroup.group) (sourceName:string) (targetName:string) = 
  SMLTool.checkLoad group targetName (SMLTool.targetNameOf targetName)

fun validTarget (group:SourceGroup.group) (sourceName:string) (targetName:string) = 
  fileExists targetName

fun compileSource (group:SourceGroup.group) (sourceName:string) (targetName:string) =
 (runLex sourceName;
  SMLTool.compileSource group targetName (SMLTool.targetNameOf targetName))

fun checkLoad (group:SourceGroup.group) (sourceName:string) (targetName:string) =
  if validTarget group sourceName targetName
    then loadTarget group sourceName targetName
    else loadSource group sourceName targetName

end;
