(* Gene Rollins
   School of Computer Science
   Carnegie-Mellon University
   Pittsburgh, PA 15213
   rollins@cs.cmu.edu *)

signature DIRFILE = sig
  datatype mapOptions = FOLLOWDIRS | FOLLOWFILES | RECURSIVE | ALPHA
  datatype fileType = FILE | DIR | SYMLINK
  val scan :(string->string->fileType->unit)->mapOptions list->string->unit
  val fold :(string->string->fileType->'a->'a)
                 ->mapOptions list->string->'a->'a
  val checkFile :string->string->bool->bool->((string*string)*fileType*bool)
  val listFiles :string -> mapOptions list -> unit
  val timeModified :string -> int
  val fileExists :string -> bool
end
