(* Test various floating point errors *)

structure Main =
   struct
       val say = outputc std_out
       val test = fn (name,f) => 
	            (say (name^"\n");
	            (f(); ()) handle e =>
			 say ("exception "^System.exn_name e^" occurred\n"))
       val _ = test ("sqrt(~2.0)",fn () => sqrt(~2.0))
       val _ = test ("sqrt(2.0)",fn () => sqrt(2.0))

       (* floor of 40 billion *)

       val _ = test ("floor(40000000000.0)",fn () => floor(40000000000.0))
       val _ = test ("floor(40.0)",fn () => floor(40.0))

       (* e^20000.0 *)

       val _ = test ("exp 20000.0",fn () => exp 20000.0)
       val _ = test ("exp 2.0",fn () => exp 2.0)

       (* ln ~1.0 *)

       val _ = test("ln ~1.0",fn () => ln ~1.0)
       val _ = test("ln 1.0",fn () => ln 1.0)
   end




