functor Par_select(Thread: THREAD):PAR_SELECT =
    struct
	open Thread
	    
	exception Abort

	fun par_select fn_arg_list =
	    let val m = mutex ()
		val c = condition ()
		val f = ref NONE

		fun fork_it (function,arg) = 
		    let fun wrapper() =
			case (!f) of
			    NONE => 
				let val result = (SOME (function arg))
				    handle Abort => NONE

				    fun deposit () =
					case (!f) of
					    NONE =>
						(f := result;
						 signal c)
					  | SOME(_) => ()
				in
				    case result of
					SOME(_) => with_mutex m deposit
				      | NONE => ()
				end
			  | SOME(_) => ()
		    in
			fork wrapper
		    end
		
		fun wait_on_it () =
		    let fun wait_on_it' () =
			case (!f) of
			    NONE => (wait m c;
				     wait_on_it'())
			  | SOME x => x
		    in
			with_mutex m wait_on_it'
		    end
			    
	    in
		app fork_it fn_arg_list;
		wait_on_it ()
	    end
    end
