(* Copyright 1989 by AT&T Bell Laboratories

   Modications:
        8/6/90: (DRT) Changed CPScomp to be parameterized by a cps code
	              generator. It was parameterized by a code generating
		      machine before.
*)

(* Copyright (c) 1991 by Carnegie Mellon University *)

functor CPScompC(structure CPSg : CPSCODEGEN
		 sharing CPSg.CPS = CPS) :
	sig type prog
	    type entrypoint
	     val compile : CPS.function * ErrorMsg.complainer * entrypoint ->
		               prog
	end =
struct
type prog = CPSg.prog
type entrypoint = CPSg.entrypoint

structure CPSopt = CPSopt(val maxfree = CPSg.numregs)
structure Closure = Closure(val maxfree = CPSg.numregs)
structure Spill = Spill(val maxfree = CPSg.numregs)

 fun timemsg (s : string) =
    if !System.Control.timings then (print s; print "\n"; true) else false

 fun write s = (if !System.Control.CG.printit then outputc std_out s else ())

    fun debugmsg  (msg : string) =
	let val printit = !System.Control.debugging
	in  if printit then (print msg; print "\n")
	    else ();
	    printit
	end

 fun time (f,m,s) x =
        let val _ = debugmsg m
	    val t = System.Timer.start_timer()
            val r = f x
	    val t' = System.Timer.check_timer t
            val _ = (write "After "; write m; write ":\n")
        in  System.Stats.update(s,t');
	    timemsg(m ^ ": " ^ System.Timer.makestring t' ^ "s");
	    flush_out(std_out);
	    r
        end

fun compile(function,err,entry) =
 let
  fun fprint (function as (f,vl,cps)) =
	  (if !System.Control.CG.printit
		then CPSprint.show write
			(CPS.FIX([function],CPS.PRIMOP(Access.P.+,[],[],[])))
		else ();
	   if !System.Control.CG.printsize then CPSsize.printsize cps else ())
  val _ = fprint function;

  val cpsopt = if !System.Control.CG.cpsopt
		then time(CPSopt.reduce,"cpsopt",System.Stats.cpsopt)
		else fn (cps,_) => cps
  val function = cpsopt(function,NONE)
  fun prof(a,b,ce) = CPS.PRIMOP(Access.P.profile, [CPS.INT a, CPS.INT b],nil,[ce])
  val _ = fprint function

  val closure   = time(Closure.closeCPS,"closure",System.Stats.closure)
  val (function,known) = closure(function,prof)
  val _ = fprint function

  val globalfix = time(GlobalFix.globalfix,"globalfix",System.Stats.globalfix)
  val carg = globalfix(function,known)
  val _ = app fprint (map #1 carg)

  val spill     = time(Spill.spill,"spill",System.Stats.spill)
  val carg = spill(carg,prof)
  val _ = (app fprint (map #1 carg); write "\n")

  val carg = Unused.clean carg

  val codegen   = time(CPSg.codegen,"codegen",System.Stats.codegen)
  val result = codegen(carg,err,entry)
  val _ = debugmsg "done"
  in result
 end
end (* functor CPScomp *)
