module  -- conutil
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/idtab.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../Expr/Expr.t.t"
#include "../Expr/Eprint.t"
#include "../Expr/Eutil.t"
#include "../misc/misc.t"
#include "../misc/util.t"
#include "../misc/flags.t"
#include "../transform/hexpr.t"
#include "subst.t.t"
#include "subst.t"
#include "prefix.t"
#include <OK>
#include <Option>

export combcon, combdict, combdicts, issuper, caply, 
       newd, newdn, resolvedefs, buildid, flatcollaps, reorder, himplies;

rec caply e es = reduce (\a.\r.Eap r a) e (reverse es)

-- combine dictionaries
and combdict D1 D2 = D1 @ D2
and combdicts Ds = conc Ds

-- is s a superclass of c
and issuper s c = member eqid s (map fst (getsups c))
and getsups (c as mkid _ _ (idi_class (clsi _ _ sup _ _)) _) = sup
||  getsups c = fail ("No match in getsups "@prid c)

-- combcon combines two contexts keeping them minimized
and combcon [] k = k		-- fast special case
||  combcon k [] = k		-- fast special case
||  combcon k1 k2 = 
let rrr =
reduce add1con k2 (reverse k1)	-- the reverse avoids upsetting the order in k1
in
if TestN > 1 then trace (force ("combcon "@show_list prassert k1@" and "@show_list prassert k2@" is "@show_list prassert rrr)) rrr else
rrr

and prassert (mkassert i v) = prttype (mktcons i [mktvar v])

and issuperk (mkassert i1 v1) (mkassert i2 v2) = v1=v2 & issuper i1 i2
and add1con k [] = [k]
||  add1con (k1 as mkassert i1 v1) (kks as (k2 as (mkassert i2 v2)).ks) & (v1 = v2) =
    if eqid i1 i2 | issuper i1 i2 then
	kks
    else if issuper i2 i1 then
	k1.filter (\(mkassert ix vx).~(v1=vx & issuper i1 ix)) ks
    else
	k2.add1con k1 ks
||  add1con k1 (k.ks) = k.add1con k1 ks
	
-- minimise a flat assertion list
and subsume k = reduce add1con [] (reverse k)

-- Resolving overloading stuff

and buildid (mkassert i _) n = mknewid ("dict"@idtostr i) n

-- Take an assertion list and turn it into a non-flat context via a substitution
and substcon al k = map (\(mkassert d v).(d, assocdef v al (mktvar v))) k

-- take a list of (Id, Assert) pairs and a non-flat context and turn this into the appropriate dictionary expression
and rebuild iks (di, mktvar tv) =
    let (i, (mkassert ci _)) = findk iks di tv in
    findf (getsups ci) (\(s,_).eqid s di) (\(s, is).caply (Evar i) (map Emkint is)) (Evar i)
||  rebuild iks (di, ot) =
    case synexpand ot in
        mktcons tt ts :
            let (mvec, mkidecl k _ ti vs) = findinst tt di in
            let c = substcon (combine (vs,ts)) k in
            caply (Evar mvec) (map (rebuild iks) c)
    ||  t : fail ("rebuild"@prttype (mktcons di [t]))
    end

and findk iks ci tv = findf iks (\(i, (mkassert xi v)). tv=v & (eqid xi ci | issuper ci xi)) (\x.x) (fail ("findk "@prid ci))

-- find the instance decl for tt in class c
and findinst tt (c as mkid _ _ (idi_class (clsi _ _ _ insts _)) _) = 
    case findit tt insts in
	None :  fail ("Cannot find inst "@prid tt@" in "@prid c)
    ||  Some x : x
    end

-- Find the (method vector, instance decl) for the type tt in a list
and findit tt ps = 
    findf ps (\(_, t).eqid tt (ityname t)) Some None

and eqa (mkassert i1 v1) (mkassert i2 v2) = v1=v2 & eqid i1 i2

-- Does k imply y?
and himplies k y =
    case flatcon y in
	No _ : false
    ||  Yes nk : all (\(mkassert d v).exists (\(mkassert c w).v=w & (eqid c d | issuper d c)) k) nk
    end

-- Given a list of (Id, Assert) pair, a context, and a (Id, (ClassId, Ttype)) pair, build the expression to select the Ttype-dictionary
and handleD iks k (j,y) & (himplies k y) = 
let rrr = Yes (j, rebuild iks y)
in
if Test then trace ("handleD "@prid j@" "@show_pair(prid,prttype) y@" to "@pr (rebuild iks y)) rrr else
rrr
||  handleD _   _ p = No p

and newdn R ie r D u = 
    let curk = extractcon (getTvars r) R in
    let is = map2 buildid curk (from u) in
    newd R curk is ie r D (u+length curk)

and newd R curk is (i,oe) r D u =
    let rec  lk = length curk
    -- add lambdas for givens ids
    and      e = reduce Elam oe is
    -- build a mapping of requested stuff if we know it by now
    and      (ies, Dns) = ynsplit (map (handleD (combine (is, curk)) curk) D) [] [] in
let rrr =
	if lk = 0 & ies = [] then		-- fast special case
	    (((i, oe), D, r, []), u)
	else
	    (((i, e), Dns, xmkcontype curk r, ies), u)
in
if Test then trace (force ("newd "@show_list prid is@" "@show_list prassert curk@" mapped "@show_list (prid o fst) ies)) rrr else
rrr

and resolv1tyvar k defs (p as (v, cis)) =
--trace ("resolv "@itos v@" "@show_list prid cis@" "@show_bool (all (\ci.member eqid ci stdClass | member eqid ci numClass) cis & exists (\ci.member eqid ci numClass) cis)@" "@show_list (\t.show_list (\ci.show_bool (himplies k (ci, t))) cis) defs) (
    if all (\ci.member eqid ci stdClass | member eqid ci numClass) cis & exists (\ci.member eqid ci numClass) cis then
	case findf defs (\t.all (\ci.himplies k (ci, t)) cis) Some None in
	    None : No ("Ambiguous overloading: tyvar a"@itos v@" classes "@mixmap oprid cis ", ")
        ||  Some t : Yes (v, t)
        end
    else
	No ("Ambiguous overloading: tyvar a"@itos v@" classes "@mixmap oprid cis ", ")
--)

and aTR (ok k _) = k
||  aTR _ = []

and resolvedefs R D defs p t =
    let kk = [] in			-- use context from current subst?
    let kkk = aTR R in
    case oktestconc (map (\(i, y).flatcon y) D) in
	No s : (bad [s])		-- Can this ever happen?
    ||  Yes k :
	let xs = union (getngs p) (getTvars t) in
	let kg = filter (\(mkassert _ v).~mem v xs) k in
        let kgvs = mkset (map (\(mkassert _ v).v) kg) in
        let kg1 = mkseteq eqa (filter (\(mkassert _ v).mem v kgvs) kkk @ kg) in
	let idss = map (\(xs as (mkassert _ v)._).(v, map (\(mkassert d _).d) xs)) (group eqasv (sort ltasv kg1)) in
let rrr =
	case ynsplit (map (resolv1tyvar kk defs) idss) [] [] in
	    (vts, []) : ok [] vts
	||  (_, (s._)) : bad [s]
	end
in
if Test then trace (force ("resolvdefs "@prttype t@" ngs="@show_list show_int (getngs p)@" kg1="@show_list prassert kg1)@" kkk="@show_list prassert kkk) rrr else
rrr
    end	

and ltasv (mkassert _ v1) (mkassert _ v2) = v1 < v2
and eqasv (mkassert _ v1) (mkassert _ v2) = v1 = v2
#if 0
and resolvedef D defs =
    let kk = [] in
    case oktestconc (map (\(i, y).flatcon y) D) in
	No s : ([s], [], emptyTR)
    ||  Yes k : 
--trace ("resolve "@show_list (\(i, (d, t)).prid i@"::"@prttype (mktcons d [t])) D) (
	    let idss = map (\(xs as (mkassert _ v)._).(v, map (\(mkassert d _).d) xs)) (group eqasv (sort ltasv k)) in
	    case ynsplit (map (resolv1tyvar kk defs) idss) [] [] in
		(vts, []) : ([], map (\(i, (d, t)).(i, rebuild kk (d, tsubst vts t))) D, ok [] vts)
	    ||  (_, (s._)) : ([s], [], emptyTR)
	    end
--)
    end
#endif

-- Take a list of non-flat assertions and turn it into a flat one
and flatcollaps k =
    case oktestconc (map flatcon k) in
	(n as No _) : n
    ||  Yes k : Yes (subsume k)
    end

-- Take a single non-flat assertion and turn it into a flat assertion list
and flatcon (d, mktvar v) = Yes [mkassert d v]
||  flatcon ((d as mkid _ _ (idi_class (clsi _ _ _ insts _)) _), ot) =
    case synexpand ot in
        (t as mktcons ti ts) : 
            case findit ti insts in
		None :  No ("Not an instance "@prttype (mktcons d [t]))
	    ||  Some (_, mkidecl k _ _ vs) :
                    let c = substcon (combine (vs, ts)) k in
		    case oktestconc (map flatcon c) in
			(n as No _) : n
		    ||  Yes k : Yes (subsume k)
		    end
            end
    end

-- reorder the current context according to another one.
-- also checks that the second is not more general than the first.
-- Is this check right??
and reorder (S as ok k1 ss) t =
    let k2 = cpart t in
    let k = map (tra ss) k2 in
--    let kv = map (\(mkassert _ v).v) k in
    let kv = getTvars (TRtype S (tpart t)) in
    let (kin, kout) = partition (\(mkassert _ v).mem v kv) k1 in
let rrr =
    if null (diffeq eqa kin k) then
	ok (k@kout) ss
    else
	bad ["Type restriction not comptible with deduced: "@prttype (TRtype S t)@", "@show_list prassert k1]
in
if Test then trace ("reorder "@show_list prassert k1@" by "@show_list prassert k2@"("@show_list (show_list prassert) [k;kin;kout]@") is "@show_list prassert (k@kout)) rrr else
rrr
||  reorder S _ = S
and tra ss (mkassert ci v) =
    case assocdef v ss (mktvar v) in
	mktvar vn : mkassert ci vn
    ||  _ : fail "Bad type var reorder"
    end
end
