%{
# include "y.tab.h"
# include <stdio.h>
extern	int yylval;
extern  FILE *fc;
#define ECHO 

%}
%%
";"			{ ECHO; return(SEMICOL); }
":"			{ ECHO; return(COLON); }
"<"			{ ECHO; return(STDEF); }
">"			{ ECHO; return(ENDDEF); }
"type"	 		{ ECHO; return(TYPE); }
"end"	 		{ ECHO; return(END); }
[A-Za-z][A-Za-z0-9_]*	{
				ECHO;
				yylval = installid(yytext);
				return(ID);
			}
.			ECHO;
"\n"			ECHO; 
"/*"([^*]|"*"[^/]|\n)*"*/" ECHO;
"%{"([^%]|"%"[^}]|\n)*"%}" {
				ECHO;
				yytext[yyleng-2] = '\0';
				fprintf(fc, "\n%s",  &yytext[2]);
			}
%%
yywrap()
{
	return(1);
}
