#include <stdio.h>
#include <sys/signal.h>
#include "include.h"

int warnflag, zyzflag, zyzid;

tree root; 		/* The root of the built syntax tree. */
impstuff iroot;
int Eflag = 0;
int interactive = 0;
int interfacef = 0;
int debug = 0;
int pedantic = 0;
static char *initialname = 0;
char *progname;
char *filename;
char *copystring();

char *malloc();
char *mtupstr();

main(argc, argv)
    int argc;
    char **argv;
{
    progname = *argv++;
    argc--;
    while (argc && argv[0][0] == '-') {
	while (*++*argv)
	    switch(**argv) {
	    case 'P':
		pedantic++;
		break;
	    case 'w':
		warnflag++;
		break;
	    case 'Z':
		zyzflag = 1;
		break;
	    case 'z':
		zyzid++;
		break;
	    case 'E':
		Eflag++;
		break;
	    case 'i':
		interactive++;
		break;
	    case 'p':
		interfacef++;
		break;
	    case 'd':
		debug++;
		break;
	    case 'f':
		initialname = (*argv)+1;
		goto nextarg;
	    }
    nextarg:
	argc--, argv++;
    }

    if(argc >= 1 && freopen(argv[0], "r", stdin) == NULL) {
	error("Cannot open %s.\n", argv[0]);
    }
    if(argc >= 2 && freopen(argv[1], "w", stdout) == NULL) {
	error("Cannot open %s.\n", argv[1]);
    }

    if (initialname)
	filename = copystring(initialname);
    else {
	if (argc >= 1)
	    filename = copystring(argv[0]);
	else
	    filename = copystring("<stdin>");
    }
    init();
    initlex();
    if (interactive) {
	signal(SIGINT, SIG_IGN);
	pushextra(INTERACTIVE);
	yyparse();
    } else if (interfacef) {
	pushextra(SINTERFACE);
	if(yyparse() == 0) {
	    /* No syntax errors. */
	    pimpstuff(iroot);
	    exit(0);
	} else {
	    /* There was a syntax error. */
	    exit(1);
	}

    } else {
	if(yyparse() == 0) {
	    /* No syntax errors. */
	    ptree(root);
	    dumperrinfo();
	    printf("\n");
	    exit(0);
	} else {
	    /* There was a syntax error. */
	    exit(1);
	}
    }
    exit(0);
}

