#include <stdio.h>
#include <varargs.h>
#include "include.h"
#include "listgen.h"

tree niltree;
list Lnil;
int warnflag = 1;
int zyzflag = 0;
int zyzid = 0;
char *progname;
extern char *malloc();
extern int curryflag;

void pid(), prbind(), plist(), pimpid(), patype(), ppbinding(), pfinfo(),
     ptree(), pttype(), pfixes(), picmd(), pqual(), prexpid(), pimpstuff();

init()
{
    niltree = mkident(installid("_[]"));
    Lnil = mklnil();
}

#if defined(sequent) || defined(vax)
vfprintf(f, fmt, va)
FILE *f;
char *fmt;
int *va;
{
    return fprintf(f, fmt, va[0], va[1], va[2], va[3]);
}

char *
vsprintf(s, fmt, va)
char *s;
char *fmt;
int *va;
{
    return sprintf(s, fmt, va[0], va[1], va[2], va[3]);
}
#endif

/*VARARGS0*/
error(va_alist)
va_dcl
{
    va_list args;
    char *fmt;

    va_start(args);
    fmt = va_arg(args, char *);
    fprintf(stderr, "%s: Error ", progname);
    vfprintf(stderr, fmt, args);
    va_end(args);
    fprintf(stderr, "\n");
    exit(1);
}

/*VARARGS0*/
errmsg(va_alist)
va_dcl
{
    va_list args;
    char *fmt;
    extern int interactive;

    va_start(args);
    fmt = va_arg(args, char *);

    if (interactive) {
	char b[1024];
	vsprintf(b, fmt, args);
	picmdmsgnp(b);
    } else
	vfprintf(stderr, fmt, args);
    va_end(args);
}

/*VARARGS0*/
normmsg(va_alist)
va_dcl
{
    va_list args;
    char *fmt;
    extern int interactive;

    va_start(args);
    fmt = va_arg(args, char *);

    if (interactive) {
	char b[1024];
	vsprintf(b, fmt, args);
	picmdmsgnp(b);
    } else
	vfprintf(stderr, fmt, args);
    va_end(args);
}

char *
mtupstr(l, n)
list l;
{
    if (tlist(l) == lcons)
	return mtupstr(ltl(l), n+1);
    else {
	char *p = malloc(10);
	sprintf(p, "P#%d", n);
	return p;
    }
}

tree
remaketuple(l)
list l;
{
    tree f = mkident(mtupstr(l, 0));

    while(tlist(l) != lnil) {
	f = mkap(f, lhd(l));
	l = ltl(l);
    }
    return f;
}

#define pint(i)	printf("#%d\t", (i));
/* 	Performs a pre order walk of the tree
**	to print it.
*/
void
ptree(t)
   tree t;
{
 again:
    switch(ttree(t)) {
    case par:
	t = gpare(t);
	goto again;
    case hmodule:
	printf("h ");
	pid(ghmodid(t));
	pimpstuff(ghexp(t), prexpid);
	plist(pimpstuff, ghimp(t));
	plist(pimpstuff, ghfix(t));
	prbind(ghbind(t));
	break;
    case module:
	printf("m ");
	pfixes();
	plist(pimpid, gimplist(t));
	plist(pid, gexplist(t));
	prbind(gmodlist(t));
	break;
    case ident: 
	printf("i "); 
	pid(gident(t));
	break;
    case integer:
	printf("I #%u\t", ginteger(t));
	break;
    case bignum:
	printf("J #%s\t", gbignum(t));
	break;
    case ratnum:
	printf("Q #%s\t", gratnum(t));
	break;
    case charr:
	printf("C #%d\t", gchar(t)[0]);
	break;
    case floatt:
	printf("F #%24.18e\t", gfloat(t));
	break;
    case string:
	printf("S #%s\t", gstring(t));
	break;
    case ap: 
	printf("a "); 
	ptree(gfun(t)); 
	ptree(garg(t)); 
	break;
    case lam: 
	printf("l ");
	ptree(glamid(t));
	ptree(glamexpr(t));
	break;
    case letv: 
	printf("e ");
	prbind(gletvdeflist(t));
	ptree(gletvexpr(t));
	break;
    case casee:
	printf("c ");
	ptree(gcaseexpr(t));
	plist(ppbinding, gcasebody(t));
	break;
    case tuple:
	ptree(remaketuple(gtuplelist(t)));
	break;
    case as:
	printf("s ");
	pid(gasid(t));
	ptree(gase(t));
	break;
    case condp:
	printf("o ");
	ptree(gcondpp(t));
	ptree(gcondpe(t));
	break;
    case lazyp:
	printf("Z ");
	ptree(glazyp(t));
	break;
    case restr:
	printf("R ");
	ptree(grestre(t));
	pttype(grestrt(t));
	break;
    case eannot:
	printf("| ");
	ptree(geannote(t));
	pid(geannota(t));
	break;
    case listf:
	printf("1 #%d\t", glistt(t));
	plist(ptree, glistf(t));
	break;
    case listg:
	printf("2 ");
	ptree(glgg(t));
	plist(pqual, glgq(t));
	break;
    default:
	error("Bad ptree");
    }
}

void
pqual(q)
qual q;
{
    switch(tqual(q)) {
    case qgen:
	printf("g ");
	ptree(gqgenpat(q));
	ptree(gqgenexp(q));
	break;
    case qfilter:
	printf("f ");
	ptree(gqfilter(q));
	break;
    default:
	error("Bad pqual");
	break;
    }
}

void
plist(fun, l)
void (*fun)();
list l;
{
    if (tlist(l) == lcons) {
	printf("L ");
	(*fun)(lhd(l));
	plist(fun, ltl(l));
    } else
	printf("N ");
}

void
pid(i)
id i;
{
    printf("#%s\t", i);
}

void
prbind(b)
binding b;
{
    switch(tbinding(b)) {
    case tbind: 
	printf("t ");
	pttype(gtbindid(b));
	plist(patype, gtbindc(b));
	pimpstuff(gtbindd(b), pid);
	break;
    case pbind: 
	printf("p ");
	plist(ppbinding, gpbindl(b));
	break;
    case abind: 
	printf("A ");
	prbind(gabindfst(b));
	prbind(gabindsnd(b));
	break;
    case rbind: 
	printf("r ");
	prbind(grbind(b));
	break;
    case lbind: 
	printf("O ");
	prbind(glbindfst(b));
	prbind(glbindsnd(b));
	break;
    case ebind:
	printf("z ");
	pttype(gebindid(b));
	pttype(gebindt(b));
	break;
    case cbind:
	printf(": ");
	pttype(gcbindt(b));
	prbind(gcbindb(b));
	break;
    case nbind:
	printf("; ");
	break;
    case ubind:
	printf("' ");
	plist(pttype, guids(b));
	break;
    case ibind:
	printf(". ");
	pttype(gitype(b));
	prbind(gibindb(b));
	break;
    case sbind:
	printf("+ ");
	plist(pid, gbsids(b));
	pttype(gbstype(b));
	break;
    default:
	error("Bad prbind");
	break;
    }
}

void
pttype(t)
ttype t;
{
    switch (tttype(t)) {
    case tname: 
	printf("T ");
	printf("#%s\t", gtypeid(t));
	plist(pttype, gtypel(t));
	break;
    case tvar: printf("y #%d\t", gtvar(t));
	break;
    case tstrict: printf("! ");
	pttype(gtstrict(t));
	break;
    case tcontext: printf("C ");
	plist(pttype, gcontexts(t));
	pttype(gctype(t));
	break;
    default:
	error("bad pttype");
	break;
    }
}

void
patype(a)
atype a;
{
    switch (tatype(a)) {
    case atc: 
	printf("1 ");
	printf("#%s\t", gatcid(a));
	plist(pttype, gatctypel(a));
	break;
    default:
	error("Bad tag in abstree %d\n", tatype(a));
    }
}

void
pimpstuff(p, f)
impstuff p;
int (*f)();
{
    switch(timpstuff(p)) {
    case import:
	printf("7 ");
	pid(gimodid(p));
	plist(pimpid, giimps(p));
	if (curryflag) {
	    plist(pimpstuff, gifixes(p));
	} else {
	    /* Hack, hack !! */
	    if (interface)
		pfixes();
	    else
		plist(pimpstuff, gifixes(p));
	}
	plist(pimpid, gients(p));
	pimpstuff(gispec(p), pid);
	plist(pimpstuff, girename(p));
	break;
    case ispec:
	printf("8 ");
	pint(giexpose(p));
	plist(prexpid, giids(p));
	break;
    case irename:
	printf("9 ");
	pid(girensrc(p));
	pid(girendst(p));
	break;
    case ifix:
	printf("0 ");
	plist(pid, gifixids(p));
	pint(gifixass(p));
	pint(gifixprec(p));
	break;
    case inone:
	printf("` ");
	break;
    case isome:
	printf("= ");
	plist(f, gisome(p));
	break;
    case interface:
	printf("^ ");
	pid(giimodid(p));
	plist(pimpid, giiimps(p));
	plist(pimpstuff, giifixes(p));
	plist(pimpid, giients(p));
	break;
    case itypinfo:
	printf("< ");
	pint(gincon(p));
	pint(giflat(p));
	break;
    default:
	error("Bad pimpstuff");
	break;
    }
}

void
prexpid(e)
expidt e;
{
    switch(texpidt(e)) {
    case expid:
	printf("3 ");
	pid(gexpid(e));
	break;
    case expdd:
	printf("5 ");
	pid(gexpdd(e));
	break;
    case exppdd:
	printf("4 ");
	pid(gexppdd(e));
	break;
    case expl:
	printf("6 ");
	pid(gexplid(e));
	plist(pid, gexpll(e));
	break;
    default:
	error("Bad prexpid");
	break;
    }
}

void
pimpid(i)
impidt i;
{
    switch (timpidt(i)) {
    case impid:
	printf("f ");
	pid(gimpid(i));
	pttype(gimptype(i));
	pfinfo(gimpfinfo(i));
	break;
    case imptype:
	printf("Y ");
	pttype(gimptypet(i));
	pimpstuff(gimpder(i), pid);
	pimpstuff(gimptypi(i), pid);
	break;
    case impeqtype:
	printf("@ ");
	pttype(gimpeqtype(i));
	plist(patype, gimpeqcon(i));
	pimpstuff(gimpeqder(i), pid);
	break;
    case impimport:
	printf("{ ");
	pid(gimpimpmodid(i));
	plist(prexpid, gimpimpexp(i));
	plist(pimpstuff, gimpimpren(i), pid);
	break;
    case impsyn:
	printf("} ");
	pttype(gimpsynsrc(i));
	pttype(gimpsyndst(i));
	break;
    case impclass:
	printf("[ ");
	pttype(gimpclasst(i));
	prbind(gimpclassd(i));
	break;
    case impinst:
	printf("] ");
	pttype(gimpinstt(i));
	pint(gimpinstd(i));
	break;
    case impids:
	printf("F ");
	plist(pid, gimpids(i));
	pttype(gimptypes(i));
	pfinfo(gimpfinfos(i));
	break;
    default:
	error("Bad pimpid");
	break;
    }
}

void
pfixes()
{
    int m = nfixes(), i;
    int s;

    for(i = 0; i < m; i++) {
	s = fixtype(i);
	if (s >= 0) {
	    printf("L 0 L ");
	    pid(fixop(i));
	    printf("N ");
	    pint(s);
	    pint(9);
	}
    }
    printf("N ");
}

void
pfinfo(f)
finfot f;
{
    switch(tfinfot(f)) {
    case nofinfo:
	break;
    case finfo: printf("* ");
	pid(fi1(f));
	pid(fi2(f));
	printf("#%d\t", fi3(f));
	break;
    default:
	error("Bad pfinfo");
    }
}

void
ppbinding(p)
pbinding p;
{
    switch(tpbinding(p)) {
    case ppat:
	printf("d ");
	ptree(gppat(p));
	ptree(gpexpr(p));
	break;
    default:
	error("Bad pbinding");
	break;
    }
}

void
picmd(p)
icmd p;
{
    switch(ticmd(p)) {
    case Iexpr:
	printf("{ ");
	ptree(gIexpr(p));
	break;
    case Ibinding:
	printf("} ");
	prbind(gIbinding(p));
	break;
    case Itload:
	printf("| ");
	ptree(gItloadname(p));
	plist(pimpid, gItloadimp(p));
	break;
    case Imload:
	printf("@ ");
	ptree(gImloadname(p));
	break;
    case Imsg:
	printf("` ");
	ptree(gImsg(p));
	break;
    case Inull:
	printf("^ ");
	break;
    default:
	error("Bad icmd");
    }
    fflush(stdout);
}

picmdmsg(s)
{
    printf("` S #%s\t", s);
    fflush(stdout);
}

picmdmsgnp(s)
{
    printf("/ S #%s\t", s);
    fflush(stdout);
}

char *
uniqueid()
{
    static int idno = 1;	/* Next identifier number */
    static char buff[10];

    sprintf(buff, "$I%d", idno++);
    return buff;
}

secprompt()
{
    picmdmsgnp("# ");
}

char *
copystring(s)
char *s;
{
    char *p;

    p = malloc(strlen(s) + 1);
    strcpy(p, s);
    return p;
}

struct errinfo {
    struct errinfo *next;
    char *func;
    char *file;
    int lineno;
} *allerrinfo;

/* Add information to the mapping from entity names to filename,line-number */
adderrinfo(func)
char *func;
{
    struct errinfo *p;
    extern int yylineno;
    extern char *filename;

    if (!func)
	return;
    for(p = allerrinfo; p; p = p->next)
	if (strcmp(p->func, func) == 0) {
	    if (yylineno < p->lineno)
		p->lineno = yylineno;
	    return;
	}
    p = (struct errinfo *)malloc(sizeof(struct errinfo));
    p->func = func;
    p->file = filename;
    p->lineno = yylineno;
    p->next = allerrinfo;
    allerrinfo = p;
}

dumperrinfo()
{
    struct errinfo *p;

    for(p = allerrinfo; p; p = p->next) {
	printf("L ");
	pid(p->func);
	pid(p->file);
	pint(p->lineno-1);		/* Subtracting 1 often gives a more correct line number !?! */
    }
    printf(" N");
}


char *
leftmostid(t)
tree t;
{
    for(;;) {
	switch(ttree(t)) {
	case par:
	    t = gpare(t);
	    break;
	case ident:
	    return gident(t);
	case ap:
	    t = gfun(t);
	    break;
	case as:
	    return gasid(t);
	case condp:
	    t = gcondpp(t);
	    break;
	case eannot:
	    t = geannote(t);
	    break;
	default:
	    return 0;
	}
    }
}
