module -- simpl
#include "../funnos.h"
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/id.t"
#include "../expr/einfo.t.t"
#include "../Expr/Expr.t.t"
#include "../Expr/Eutil.t"
#include "../Expr/Eprint.t"
#include "../Expr/Esubst.t"
#include "../Expr/Egetid.t"
#include "../misc/misc.t"
#include "../misc/util.t"
#include "../misc/flags.t"
#include "../transform/hexpr.t"
#include "casetr.t"
#include "asimpl.t"
#include "mlet.t"
#include "sutil.t"

-- The reference counting used to determine if substitution should be
-- performed is a kludge.  It should be redone, maybe using attributes.

export Esimpl, simpl;
rec
-- noinnercase checks if the default expressions is reachable by a jump.
-- (could be better!)
    noinnercase _ (Efailmatch 0) = true
||  noinnercase es _ = (all ncase es
    where
	ncase (_,_,(Ecase _ _ _)) = false
    ||  ncase _ = true
    )
and iscase (Ecase _ _ _) = true
||  iscase _ = false
and
    constfold d Fadd [e1;e2] = Emkint(e1 + e2)
||  constfold d Fsub [e1;e2] = Emkint(e1 - e2)
||  constfold d Fmul [e1;e2] = Emkint(e1 * e2)
||  constfold d Fdiv [e1;e2] & (e2 ~= 0) = Emkint(e1 / e2)
||  constfold d Fmod [e1;e2] & (e2 ~= 0) = Emkint(e1 % e2)
||  constfold d Fneg [e1] = Emkint(-e1)
||  constfold d Ford [e1] = Emkint(e1)
||  constfold d Fchr [e1] = Emkchar(chr e1)
||  constfold d Feq [e1;e2] = Emkbool(e1  = e2)
||  constfold d Fne [e1;e2] = Emkbool(e1 ~= e2)
||  constfold d Flt [e1;e2] = Emkbool(e1 <  e2)
||  constfold d Fle [e1;e2] = Emkbool(e1 <= e2)
||  constfold d Fgt [e1;e2] = Emkbool(e1 >  e2)
||  constfold d Fge [e1;e2] = Emkbool(e1 >= e2)
||  constfold d _ _ = d

and casefold u d (Econstr c es) cies de =
	assocdef (cval c)
		(map (\(c,is,e).(cval c,
			if e = Efailmatch 1 then
				(u, de)
			else
				mlet u d (combine (is, es)) e)) cies)
		(u, de)

-- Make an alpha-converted copy of an expression to avoid name clashes
and clone u e =
	case Egetlamid e in
	   [] : (u, e)		-- Optimize simple case
	|| is : let iis = map2 (\(i as mkid _ a b on).\n.(i, mkid n a b on)) is (from u) in
		(u+length is, Ealphasubst iis e)
	end

and Esimpl u (Emodule i e iess) =
    let (iess', uu') = (Umap (Umap f) iess u
        where f (i, e) u =
	    let (u', e') = simpl u [] (movelam e) in
	    let (u'', e'') = farity u' e' in
	    ((i, e''), u''))
    in (uu', Emodule i e iess')

-- Force the arity if requested
and farity u (Einfo (forcearity n) e) =
        case e in
	    Elamapl is _ [] & (length is = n) : (u, e)
	||  Elamapl is e [] & (length is > n) : (u, Elamapl (head n is) (Elamapl (tail n is) e []) [])
	||  Elamapl is e [] & (length is < n) : 
		let nis = map (mknewid "XX") (count u (u+(n-length is)-1)) in
		(u+n-length is, Elamapl (nis@is) (apply (map (\i.Eidapl i []) nis) e) [])
        ||  e : let is = map (mknewid "XX") (count u (u+n-1)) in 
		(u+n, Elamapl is (apply (map (\i.Eidapl i []) is) e) [])
        end
||  farity u e = (u, e)

and movelam (Ecase e cies de) =
    Ecase (movelam e) (mapthd movelam cies) (movelam de)
||  movelam (Elet r ies e) =
    let ies' = mapsnd movelam ies in
    case movelam e in
	Elamapl is e' [] & (all f ies' where f (_,Elamapl _ _ _) = true || f _ = false) : Elamapl is (Elet r ies' e') []
    ||  e' : Elet r ies' e'
    end
||  movelam (Econstr c es) = 
    Econstr c (map movelam es)
||  movelam (Eidapl i es) =
    Eidapl i (map movelam es)
||  movelam (Elamapl is e es) = 
    Elamapl is (movelam e) (map movelam es)
||  movelam (Einfo i e) =
    Einfo i (movelam e)
||  movelam (e as Efailmatch n) = e
||  movelam _ = fail "movelam"

and apply es e = (A e
    where rec
    A (Ecase e cies de) = Ecase e (mapthd A cies) (A de)
||  A (Elet r ds e) = Elet r ds (A e)
||  A (oe as Eidapl i [_]) & (isidfail i) = oe		-- Pfail only takes 1 argument no matter what!
||  A (Eidapl i es1) = Eidapl i (es1@es)
||  A (Elamapl is e es1) = Elamapl is e (es1@es)
||  A (Efailmatch n) = Efailmatch n
||  A (Einfo i e) = Einfo i (A e)
||  A e = fail ("apply:"@pr e)
)

and simpl u d e =
/*
trace (	"simpl "@
	show_list (show_pair(pprid,pr)) d@"\n"@
	pr e @ "==>\n" @ pr (snd r) @ "\n") r
where r =
*/
    (S u e
    where rec
    S u (Ecase e cies de) =
	let (u', ne) = S u e in
	if CaseOpt & iscase ne then
		S u (casetr (Ecase ne cies de))
	else
	let (u'', ncies) = (mapstate f u' cies
	    where f u (c, is, e) = (let (u', e') = S u e in
				    let v = refc (xgetid e') in
				    (u', (c, map g is, e'))
		where g i = if assocdefeq eqid i v 0 > 0 then i else dummyid))
	in
	let (u''', nde) = S u'' de in
	if isc ne & noinnercase ncies de then
		casefold u''' d ne ncies nde
	else
		(u''', Ecase ne ncies nde)
||  S u (Elet r ies e) =
	if ~r then mlet u d ies e
	else mletr u d ies e
||  S u (Econstr c es) = 
	let (u', es') = mapstate S u es
	in (u', Econstr c es')
||  S u (Eidapl i es) & (id_is_predef i)=
-- All predefined are strict so the case optim is safe
	let (u', nes) = mapstate S u es in
	if CaseOpt & exists iscase nes then
		S u (casetr (Eidapl i nes))
	else
	if all isc nes then 
		(u', constfold (Eidapl i nes) (id_no i) (map value nes))
	else
		(u', asimpl (Eidapl i nes))
||  S u (ie as Eidapl i []) = clone u (assocdefeq eqid i d ie)
||  S u (Eidapl i es) =
	let (u', es') = mapstate S u es in
	let (u'', e) = clone u' (assocdefeq eqid i d (Eidapl i [])) in
	case apply es' e in
	   (n as Elamapl _ _ _) : simpl u'' d n
	|| n : (u'', n)
	end
||  S u (Elamapl is e []) = -- Opt.
	let (u', e') = S u e in
	(u', Elamapl is e' [])
||  S u (Elamapl is (Elamapl is' e []) es) =
	S u (Elamapl (is@is') e es)
||  S u (Elamapl is e es) = 
	let ies = combine(is, es)
	and ni = length is
	and ne = length es in
	if ni > ne then
		case mlet u d ies e in
		   (u', Elamapl is' e' []) : (u', Elamapl (tail ne is @ is') e' [])
		|| (u', e') : (u', Elamapl (tail ne is) e' [])
		end
	else if ni < ne then
		let (u', es') = mapstate S u (tail ni es) in
		mlet u' d ies (apply es' e)
	else
		mlet u d ies e
||  S u (Einfo i e) =
	let (u', e') = S u e in
	(u', Einfo i e')
||  S u (Efailmatch n) = (u, Efailmatch n)
||  S u _ = fail "simpl"
)
end

