int m_myid = 0;

int chunksize = 10*1024*1024;	/* use a large chunk for now */
int **ch_hp, **ch_end;
int no_chunks;
int wantgc = 0;
int **realehp;

int **nextresp;			/* used in Dialogue I/O */

/* Compute the new value of the heapsize */
/*ARGSUSED*/
static int
newheapsize(lastused, lastsize)
int lastused, lastsize;
{
#if 0
    return Heapsize;
#else
    return min(max(4 * lastused, MinHeapsize), Heapsize);
#endif
}

static int **
gcstk(ghp)
int **ghp;
{
    int **p;
    int *chkval;
    extern int **chkaddr;

#if DUMP
    if (stopaddr)
	fprintf(stderr, "stop at %x\n", stopaddr);
    if (chkaddr)
	chkval = *chkaddr;
    Gno--;
    if(Gflag && Gno <= 0){
	fprintf(stderr, "\nbefore GC proc=%d (%d):\n", m_myid, bos-ep);
	for(p = ep; p < bos; p++){
	    fprintf(stderr, "\n%x: ", p);
	    dumpgraph((int **)p[0], dumpdepth);
	}
	fprintf(stderr, "\n");
    }
#endif

    /* Do GC for each pointer on the stack. */
    hp = ghp;
    for(p = ep; p < bos; p++){
#if DUMP
	if (Gflag && Gno <= 0) {
	    fprintf(stderr, "gc %x %x\n", p[0], p);
	    if (p == stopaddr)
		debstop();
	    if (chkaddr && *chkaddr != chkval) {
		debstop();
		fprintf(stderr, "call changed %x: %x->%x\n", chkaddr, chkval, *chkaddr);
	    }
	}
#endif
	gc(p[0], p);
    }
    collectfiles();
    /* Relocate nextresp if necessary */
    if (nextresp) {
	extern int *MOVED[];
	if (nextresp[0] == (int *)MOVED) {
	    nextresp = (int **)nextresp[1];
	}
    }

#if DUMP
    if(Gflag && Gno <= 0){
	fprintf(stderr, "\nafter GC:\n");
	for(p = ep; p < bos; p++){
	    fprintf(stderr, "\n%x: ", p);
	    dumpgraph((int **)p[0], dumpdepth);
	}
	fprintf(stderr, "\n");
    }
#endif

    ehp = 0;			/* Force newchunk() soon */
    return hp;
}


dogc()
{
    int **p;
    static int **gc_hp;
    
    if (hp > realehp+HCLAIM) {
	/* The heap has been overrun */
	fprintf(stderr, "Warning: heap overrun: %x %x %x\n", hp, ehp, realehp);
    }
    /* Before we switch heaps, find out how much heap has been used etc.
     */
    GCstart(ep, bos, curheap, ch_hp);

#if GCSTAT
    if (Sflag>1) {
	fprintf(stderr, "enter gcstack\n");
	fprintf(stderr, "gcstack: cur=%x nxt=%x hp=%x ehp=%x\n",
		curheap, nxtheap, hp, ehp);
    }
#endif /* GCSTAT */

    /* Switch heaps. */
    { int **p = nxtheap; nxtheap = curheap; curheap = p;}

    gc_hp = curheap;
    ehp = curheap + Heapsize;
    gc_hp = gcstk(gc_hp);

    heapsize = newheapsize(gc_hp-curheap, heapsize);

    /* Find out how much graph was moved. */
    GCend(ep, bos, curheap, hp, heapsize);

    ch_hp = gc_hp;
    ch_end = curheap + heapsize;

    if(ch_hp+Minleft > curheap+Heapsize){
	noheapleft();
    }
#if GCSTAT
    if (Sflag>1){
	fprintf(stderr, "leave gcstack\n");
	fprintf(stderr, "gcstack: cur=%x nxt=%x hp=%x ehp=%x\n",
		curheap, nxtheap, ch_hp, ch_end);
    }
#endif /* GCSTAT */

    wantgc = 0;
}

setupheap()
{
    int retry;
    extern int heapsize, Heapsize;

    if (heapsize > Heapsize)
	heapsize = Heapsize;
    for (retry = 0;; retry++) {
	startheap = (int **) sbrk(2 * sizeof(int *) * Heapsize);
	if (startheap != (int **) - 1)
	    break;
	/* No memory available, this is probably due to fragmentation
	 * of the swap space and will (hopefully) disappear soon. */
	fprintf(stderr,
		"*** Cannot allocate %d bytes for the heaps.\n",
		2 * sizeof(int *) * Heapsize);
	if (retry > 10)
	    finish(1);
	fprintf(stderr, "Trying again\n");
	sleep(20);
    }
    endheap = startheap + 2 * Heapsize;
    curheap = ch_hp = startheap;
    nxtheap = startheap + Heapsize;/* heap half after next gc */
    ch_end = startheap + heapsize;

}

#ifdef sparc
int **vp;
#define VSIZE 50000
#endif

setupstack()
{
    extern int stacksize;

    stack = (int **) sbrk(sizeof(int *) * stacksize);/* stack */
    if (stack == (int **)-1) {
	fprintf(stderr, "No room for stack\n");
	finish(1);
    }
    ep = bos = stack + stacksize;
#ifdef sparc
    vp = (int **)sbrk(sizeof (int *) * VSIZE) + VSIZE;
#endif
}

newchunk(force)
     int force;
{
    extern intrflag, doinggc;

    doinggc++;
    if (intrflag) {
	intrflag = 0;
	ehp = realehp;
	cleansig();
	failintr();
    }

    if (force || ch_hp >= ch_end) /* There is no heap left */
	dogc();			  /* Do actual gc */

    hp = ch_hp;
    ch_hp += chunksize;
    ehp = ch_hp;
    if (ehp > ch_end)
	ehp = ch_end;
    ehp -= HCLAIM;
    no_chunks++;
    realehp = ehp;
    
    if (intrflag) {
	intrflag = 0;
	cleansig();
	failintr();
    }
    doinggc = 0;
}

gc_sync()
{
    if (done)
	longjmp(haltproc, 1);
    dogc();
}

collectfiles() {}

debstop() {}
