#define MAXDUMP	10000		/* never dump more nodes than this */
int maxdump = MAXDUMP;
int dumpdepth = 5;

extern int 	*INT[], *DFLOAT[], *CHAR[], *TAG[], *TAG0[],
		*PAIR0[], *PAIR1[], *PAIR2[], *PAIR3[], *PAIR4[],
		*STRING[], *VEK[], *BVEK[], *DVEK[],
		*MARKED[], *MOVED[], *AP[], *FUN[], *VAP[],
#if 0
                *INDIR[], *UPDTAG[],
#endif
		*HOLE[], *INPUT[], *FILP[], *GCRET[], *BIGNUM[];

char *
tagname(p)
int **p;
{
	if(p == INT) return "INT";
	if(p == DFLOAT) return "DFLOAT";
	if(p == BIGNUM) return "BIGNUM";
	if(p == CHAR) return "CHAR";
	if(p == TAG) return "TAG";
	if(p == TAG0) return "TAG0";
	if(p == PAIR0) return "PAIR0";
	if(p == PAIR1) return "PAIR1";
	if(p == PAIR2) return "PAIR2";
	if(p == PAIR3) return "PAIR3";
	if(p == PAIR4) return "PAIR4";
	if(p == VEK) return "VEK";
	if(p == BVEK) return "BVEK";
	if(p == DVEK) return "DVEK";
	if(p == HOLE) return "HOLE";
	if(p == STRING) return "STRING";
	if(p == INPUT) return "INPUT";
	if(p == FILP) return "FILP";
	if(p == AP) return "AP";
	if(p == FUN) return "FUN";
	if(p == VAP) return "VAP";
	if(p == MARKED) return "MARKED";
	if(p == MOVED) return "MOVED";
	if(p == GCRET) return "GCRET";
	return "function";
}

dumpgraph(pa,d)
int **pa;	/* node pointer */
#define p ((int ***)pa)
{
	static int dcount;

	/* To prevent megabyte dumps */
	if (++dcount > MAXDUMP) {
	    fprintf(stderr, "Too many cells dumped.\n");
	    finish(1);
	}
	fprintf(stderr, "<%x %d>", pa, 
		pa < startheap ? 	 0 : 
		pa > endheap   ?    	 0 :
		pa < startheap+Heapsize ?1 :
			 		 2
		);
	if(d == 0){
		fprintf(stderr, "(...)");
	} else if(p[0] == INT){
		fprintf(stderr, "(INT %d)", p[1]);
	} else if(p[0] == DFLOAT){
		fprintf(stderr, "(DFLOAT %g)", *(double *)(&p[1]));
	} else if(p[0] == BIGNUM){
		fprintf(stderr, "(BIGNUM ");
		dumpgraph(p[1], d-1);
		fprintf(stderr, ")");
	} else if(p[0] == CHAR){
		fprintf(stderr, "(CHAR %c)", p[1]);
	} else if(p[0] == TAG){
		fprintf(stderr, "(TAG %d ", p[1]);
		dumpgraph(p[2], d-1);
		fprintf(stderr, ")");
	} else if(p[0] == TAG0){
		fprintf(stderr, "(TAG0 %d)", p[1]);
	} else if(p[0] == PAIR0){
		fprintf(stderr, "(PAIR0 ");
		dumpgraph(p[1], d-1);
		dumpgraph(p[2], d-1);
		fprintf(stderr, ")");
	} else if(p[0] == PAIR1){
		fprintf(stderr, "(PAIR1 ");
		dumpgraph(p[1], d-1);
		dumpgraph(p[2], d-1);
		fprintf(stderr, ")");
	} else if(p[0] == PAIR2){
		fprintf(stderr, "(PAIR2 ");
		dumpgraph(p[1], d-1);
		dumpgraph(p[2], d-1);
		fprintf(stderr, ")");
	} else if(p[0] == PAIR3){
		fprintf(stderr, "(PAIR3 ");
		dumpgraph(p[1], d-1);
		dumpgraph(p[2], d-1);
		fprintf(stderr, ")");
	} else if(p[0] == PAIR4){
		fprintf(stderr, "(PAIR4 ");
		dumpgraph(p[1], d-1);
		dumpgraph(p[2], d-1);
		fprintf(stderr, ")");
	} else if(p[0] == AP){
		fprintf(stderr,  "(AP ");
		dumpgraph(p[1], d-1);
		dumpgraph(p[2], d-1);
		fprintf(stderr, ")");
	} else if(p[0] == FUN){
	        if (Gflag > 1) {
		    fprintf(stderr,  "(FUN %x ", p[1]);
		    dumpfuninfo(p[1], d);
		    fprintf(stderr, ")");
		} else {
		    fprintf(stderr,  "(FUN %x)", p[1]);
		}
	} else if(p[0] == VAP){
		int i, m;
		m = *pa[1];
		fprintf(stderr,  "(VAP %x %d ", p[1], m);
		if (Gflag > 1) {
		    dumpfuninfo(p[1], d);
		}
		for(i = 0; i < m; i++){
			dumpgraph(p[2+i], d-1);
		}
		fprintf(stderr, ")");
	} else if(p[0] == STRING){
		fprintf(stderr, "(STRING \"%s\")", p[1]);
	} else if(p[0] == VEK){
		int i;
		fprintf(stderr, "(VEK %d ", p[1]);
		for(i = 0; i < (int)p[1]; i++){
			dumpgraph(p[2+i], d-1);
		}
		fprintf(stderr, ")");
	} else if(p[0] == BVEK){
	    fprintf(stderr, "(BVEK %d ", p[1]);
	    fprintf(stderr, ")");
	} else if(p[0] == DVEK){
	    int i, m = (int)p[1];
	    fprintf(stderr, "(DVEK %d ", p[1]);
	    for(i = 0; i < m; i++)
		fprintf(stderr, "%08x ", p[i+2]);
	    fprintf(stderr, ")");
	} else if(p[0] == MARKED){
		fprintf(stderr, "(MARKED) ");
	} else if(p[0] == MOVED){
		fprintf(stderr, "(MOVED %x) ", p[1]);
	} else if(p[0] == HOLE){
		fprintf(stderr, "(HOLE) ");
	} else if(p[0] == INPUT){
		fprintf(stderr, "(INPUT %x) ", p[1]);
	} else if(p[0] == FILP){
		fprintf(stderr, "(FILP %x) ", p[1]);
	} else {
		fprintf(stderr, "(BADTAG %x)", p[0]);
	}
#undef p		
}

dumpstack()
{
	int **p;

	if (!dflag)
		return;
	fprintf(stderr, "\nPointer stack dump:\n\n");
	for(p = ep; p < bos; p++){
		fprintf(stderr, "%8x:  ", p);
		dumpgraph((int **)*p, dumpdepth);
		fprintf(stderr, "\n");
	}
	fprintf(stderr, "End pointer stack dump\n\n");
}

dumpfuninfo(p, n)
int **p, n;
{
    int i, k;

    if (n > 0) {
	n--;
	fprintf(stderr, "%s=[%d %x %x %d %d (%d ", lookup(p), p[0], p[1], p[3], p[5], p[6], p[7]);
	k = (int)p[7];
	for(i = 0; i < k; i++) {
	    dumpgraph(p[8+i], n);
	    fprintf(stderr, ",");
	}
        fprintf(stderr, ")]");
    } else
	fprintf(stderr, "...");
}

dumpvtop(v)
int **v;
{
    int *data = v[0], *addr=v[1];
    if (!Gflag)
	return;
    fprintf(stderr, "vtop=%x is %x %x", v, addr, data);
    fprintf(stderr, " %x\n", *data);
    if (chkaddr == (int **)addr)
	debstop();
}
