module -- renameclass
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t.t"
#include "../expr/einfo.t.t"
#include "../expr/types.t.t"
#include "../expr/id.t"
#include "../expr/ttype.t"
#include "../misc/util.t"
#include "renameutil.t"
#include "renenv.t"
#include "renametype.t"
#include "renamedef.t"
#include "classutil.t"
#include <Option>
#include <OK>
export renclass, reninst, makemetid, makedefid, renin;
rec renclass ff env u (mkbclass cl b) =
	case cl in
	    mkcdecl _ (mkassert (mkids s) _):
		let rec   ci = mkid u s (idi_class cli) (ff ci)
		and      (cl' as mkcdecl _ k1) = rencls ci env cl
		and     iits = map2 (doiit env (u+1) [k1] (id_visibility ci) cli s ff) (concmap flatsign (extractsign b)) (from 0)
		and     menv = rlist Kvalue ( (map (\(_,i,_).i) iits) @ map (\(i,_,_).i) iits )
		and     eenv = rjoin1 menv Ktype ci
		and      cli = clsi cl' iits [] [] 0
		and (u', b', defs) = rendef ff (rjoin eenv env) (u+1+2*length iits) b in
		(u', (if chkdefs defs menv then mkbclass cl' b' else mkberror ("Extra definitions in class "@s)), eenv)
	end

and extractsign b = filter issign (listify b)
and issign (mkbsign _ _) = true
||  issign _ = false
and flatsign (mkbsign is t) = map (\i.(i, t)) is
and doiit env u k vis cli ms ff (i, t) n =
    let s = idtostr i in
    let t' = rentype env t in
    (updvis vis (makedefid u n s ms (mktcontype k t') ff),
     makemetid u n s cli ff,
     mktcontype k t')

and rencls ci env (mkcdecl k (mkassert _ v)) = mkcdecl (sortcon (map (rencontext env) k)) (mkassert ci v)
||  rencls ci _ _ = mkcdecl [] (mkaerror "Malformed class declaration")

-- could do better than f_unk
and makedefid u n s ms tt ff =
    let ds = makedefstr ms s in 
    let rec ii = mkid (u+2*n+1) ds (idi_var (var_global f_unk) (Ohastype tt (getTvars tt))) (ff ii) in ii
and tarity (mktcons (mkid _ "P->" _ _) [_;t]) = 1+tarity t
||  tarity _ = 0
and ma n (clsi _ iits _ _ _) = let (_,_,t) = select (n+1) iits in tarity t
and makemetid u n s cli ff = 
	let rec ii = mkid (u+2*n) s (idi_method [n] (ma n cli) cli) (ff ii) in ii
and makedefstr ms s = "DD."@tl ms@"."@tl s
and chkdefs defs menv = null (difference (rstrs Kvalue defs) (rstrs Kvalue menv)) & null (rstrs Ktype defs)

and reninst ff env u (mkbinstance idcl b _) =
        let rec (u', b', defs) = rendef ff env u b
        and (iid, u'') = buildinstid ff u' idcl idcl' false
	and iits = cliof idcl'
        and idcl' = renin env idcl
        and b'' = if chkinst defs iits then
	              mkbinstance idcl' b' (Some iid)
		  else
		      mkberror ("Instance declaration contains extra bindings: "@prttype (idecl2type idcl))
	in
-- Cannot add instance methods here since they cannot be computed wihout
-- the environment, i.e. a data loop.
	(u'', b'', rone Ktype iid)

--(u', trace ("reninst "@prttype (idecl2type idcl)@"\n"@show_bool (chkinst defs iits)) b', rnil)

and chkinst defs iits = null (difference (rstrs Kvalue defs) (map (\(_,m,_).idtostr m) iits)) & null (rstrs Ktype defs)

-- The code is a little weird here to avoid data dep. loops.
and renin env (mkidecl k (mkids s) ti vs) =
    	let i = rfind Ktype s env in
	let k' = map (rencontext env) k in
	let (ti, msg) =
	    case rentype env (mktcons ti (map mktvar vs)) in
		mkterror s : (mkid 0 s idi_varu noorigname, s)
	    ||  mktcons nti _ : (nti, "")
	    end in
        let k'' = if msg ~= "" then
	              [mkaerror msg] 
		  else if ~id_isclass i then
		      [mkaerror ("Unknown class in instance declaration "@s)]
		  else 
		      k'
        in
	mkidecl k'' i ti vs
end
