--
-- $Header: /ufs/usr.src/local/lml/src/rename/RCS/fun.m,v 2.9 89/12/04 22:54:56 augustss Exp $
--
module -- fun
--
-- Turn function definitions (perhaps with pattern matching) into
-- lambda expressions (perhaps with case).
--
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t.t"
#include "../expr/einfo.t.t"
#include "../expr/types.t.t"
#include "../expr/id.t"
#include "../expr/pprint.t"
#include "../transform/misc.t"

export fixfun;
rec
    newid n = mkident (mkids ('A'.itos n))
and fdef funid expr = mkbpat [(funid, expr)]
and pe [] [] = []
||  pe (p.ps) (((mkcondp _ c), e).pes) = ((mkcondp p c), e).pe ps pes
||  pe (p.ps) ((_, e).pes) = (p,e).pe ps pes
-- Try to keep old argument name if possible.
and new cp iss = map2 (\is.\n.
		       let vs = filter (\v.isI v & (let (mkident i) = v in ~ cp i & ~ isdummy i)) is in
		       if length vs > 0 & allsame vs then
			   hd vs
		       else
			   newid n)
		      iss (from 1)
and mtuple l = revitlist (\a.\f.mkap f a) l (mkident (mkids (tupstr (length l))))
and fixfun cp pl =
        let (efunid.erest) = map (leftmost o ppart) pl in
	case efunid in
	    mkident funid :
		if allsame (efunid.erest) then --all ids alike ?
                    let parll = map (argl o ppart) pl in
		    if allsame (map length parll) then
		        let ppl = transpose parll in
			if length (hd parll) = 1 then	-- treat one argument specially
			    let [nid] = new cp ppl in
			    case pe (map hd parll) pl in
				[((p as mkident i), e)] & (nid = p | isdummy i) : fdef efunid (mklam nid e)	-- fast special case: one argument, no patterns
			    ||  pes : fdef efunid (mklam nid (mkcase nid pes))
			    end
			else			-- many args, make a tuple
			    let nidl = new cp ppl in
			    fdef efunid (itlist mklam nidl (mkcase (mtuple nidl) (pe (map mtuple parll) pl)))
		    else
			mkberror ("Varying number of args to "@oprid funid)
		else
		    mkberror ("Different function names at "@oprid funid)
	|| e : mkberror ("Bad function:"@ppr e)
	end
end
