module
#include "../misc/flags.t"
#include "../expr/types.t.t"
#include "../expr/constr.t.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/einfo.t.t"
#include "../expr/idtab.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/impexp.t.t"
#include "../expr/tinfo.t"
#include "../expr/pprint.t"
#include "../misc/util.t"
#include "../misc/misc.t"
#include "renenv.t"
#include <Option>
export ciidtab, chkundefs, dbldefs, changeid, sortcon;
-- Build an id table from instance and superclass info.
rec ciidtab xc2i xt2i xcss env =
    let vids = rids Kvalue env
    and tids = rids Ktype env
    and mids = rids Kmodule env in
    let rec idtb = (itmake (concmap (mergedups o map idt) [vids; tids; mids])   -----itmake (mergedups (map idt ids))
-- translate all ids in an id
    where rec idt (i as mkid u s ii on) =
        let ii' =
	case ii in
	    idi_udef : ii
	||  idi_var vi Onotype : ii
        ||  idi_var vi (Ohastype t vs) :
		idi_var vi (Ohastype (tt t) vs)
        ||  idi_constr t tbs n ats :
		idi_constr (tt t) (mapfst tt tbs) n (map at ats)
        ||  idi_type t n ti ts ois :
		idi_type (tt t) n (tit ti) (ass (tname t) t2i) (oap (map idl) ois)
	||  idi_syn t n d :
		idi_syn (tt t) n (tt d)
	||  idi_class c :
		idi_class (ct c)
	||  idi_method is i c :
		idi_method is i (ct c)
	||  idi_inst t is b :
		let (t' as mkidecl _ ci ti _) = intt t in
		idi_inst t' (addsupermet ci ti @ map idl is) b
        ||  idi_module es :
		idi_module (map et es)
        end in
        mkid u s ii' on
    and intt (mkidecl aas ci ti vs) = mkidecl (map att aas) (idl ci) (idl ti) vs
    and tit (mktinfo t n x y ats) = mktinfo (tt t) n x y (map at ats)
    and tt (mktcons i ts) = mktcons (idl i) (map tt ts)
    ||  tt (mktcontype ts t) = mktcontype (map att ts) (tt t)
    ||  tt t = t
    and att (mkassert i v) = mkassert (idl i) v
    ||  att a = a
    and at (mkcons i tbs) = mkcons (idl i) (mapfst tt tbs)
    and ct (clsi (mkcdecl aas (a as mkassert cc _)) iits _ _ _) = 
	let ss = ass cc css in
	clsi (mkcdecl (map att aas) (att a)) (map (\(x,y,t).(idl x, idl y, tt t)) iits) ss (ass cc c2i) (length (filter (\(_,is).length is=1) ss))
    and idl i = itlookup idtb i
    and et (mkexpid i) = mkexpid (idl i)
    ||  et (mkexpidall i) = mkexpidall (idl i)
    ||  et (mkexpidsome i is) = mkexpidsome (idl i) is
    ||  et (mkexpidmodall i) = mkexpidmodall (idl i)
    and c2i = mapsnd (map (\(i, t).(idl i, intt t))) xc2i
    and t2i = mapsnd (map intt) xt2i
    and css = mapsnd (mapfst idl) xcss)
    in idtb

and ass i al = assocdefeq eqid i al []
and oap f None = None
||  oap f (Some x) = Some (f x)

and sortcon k = sort (\(mkassert x _).\(mkassert y _).last (id_orignames x) < last (id_orignames y))
                     (mkseteq (\(mkassert x _).\(mkassert y _).last (id_orignames x) = last (id_orignames y)) k)

-- Get identifiers for the (immediate) superclass vectors
and addsupermet (mkid _ _ (idi_class (clsi _ _ sis _ _)) _) ti =
    -- don't use sorting, instead each superclass level is assumed to be sorted before
    let ss = (/*sort ltstr o*/ map fst o filter (\(s, is).length is = 1)) sis in	-- sorted superclasses
    map (\(mkid _ _ (idi_class (clsi _ _ _ insts _)) _). findt ti insts) ss
and ltstr (mkid _ _ _ (Orignames _ _ n1)) (mkid _ _ _ (Orignames _ _ n2)) = last n1 < last n2
and findt ti ps = findf ps (\(v, mkidecl _ _ xi _).eqid xi ti) fst (fail ("Cannot find superclass instance for "@prid ti))

-- Check for multiple definitions in the symbol table
and dbldefs mid env = 
    let mids = idtostr mid in
    if AllowRedef then [] 
    else map tl (dbl mids Kvalue env @ dbl mids Ktype env)
and dbl mid k env = (map (idtostr o hd) o filter (baddbl mid) o filter (\is.length is > 1) o group (\i1.\i2.idtostr i1 = idtostr i2) o sort (\i1.\i2.idtostr i1 < idtostr i2) o rids k) env
-- multiple import definitions where the original names are the same are OK.
and baddbl mid ids =
    let ons = map id_orignames ids in
    ~allsame ons

-- Check for undefined ids in the symbol table
and chkundefs env = concmap undef (rids Kall env)
and undef (mkid _ _ (idi_type t _ ti _ ods) _) = undeft t @ concmap (\(mkcons _ tbs).concmap (\(t, _).undeft t) tbs) (get_cs_from_tinfo ti)
||  undef (mkid _ _ (idi_syn _ _ t) _) = undeft t
||  undef (mkid _ _ (idi_class (clsi t iits _ _ _)) _) = undefc t @ concmap (\(_,_,t).undeft t) iits
||  undef (mkid _ _ (idi_inst i _ _) _) = undefi i
||  undef i = uid i
and undeft (mktcontype ts t) = concmap undefa ts @ undeft t
||  undeft (mktcons i ts) = uid i @ concmap undeft ts
||  undeft (mkterror s) = [s]
||  undeft (mktvar _) = []
and undefi (mkidecl aas ci ti _) = concmap undefa aas @ uid ci @ uid ti
and undefa (mkassert i _) = uid i
||  undefa (mkaerror s) = [s]		-- not quite right, but...
and undefc (mkcdecl aas a) = concmap undefa aas @ undefa a
and uid (mkid 0 s _ _) = [tl s]
||  uid (mkids s) = fail ("Not renamed "@s)
||  uid _ = []

-- Change all identifiers in an expression
and changeid ff e = (ci e
where rec
    ci oe =
	case oe in
	   (mkap f a) :  mkap (ci f) (ci a)
	|| (mklam p e) : mklam (ci p) (ci e)
	|| (mkcase e cl) : mkcase (ci e) (map cip cl)
	|| (mkletv b e) : mkletv (cib b) (ci e)
	|| (mkident i) : mkident (ff i)
	|| (mkmodule i fl il el b) : mkmodule i fl il (map cie el) (cib b)
	|| (mkconst c) : oe
	|| (mkerror _) : oe
	|| (mkas i p) : mkas (ff i) (ci p)
	|| (mkcondp p c) : mkcondp (ci p) (ci c)
	|| (mklazyp p) : mklazyp (ci p)
	|| (mkconstr c el) : mkconstr (cic c) (map (ci) el)
	|| (mkfailmatch _) : oe
	|| (mkinfo t e) : mkinfo (cif t) (ci e)
	|| (mklistg e qs) : mklistg (ci e) (map ciq qs)
	end
and ciq (mkqgen p e) = mkqgen (ci p) (ci e)
||  ciq (mkqfilter e) = mkqfilter (ci e)
and cib d =
	case d in
	   (mkbtype t ats ois) : mkbtype (cit t) (map ciat ats) (oap (map ff) ois)
	|| (mkbpat pl) : mkbpat (map cip pl)
	|| (mkbmulti p e) : let (np,ne) = cip (p,e) in mkbmulti np ne
	|| (mkband b1 b2) : mkband (cib b1) (cib b2)
	|| (mkbrec b) : mkbrec (cib b)
        || (mkberror _) : d
	|| (mkblocal b1 b2) : mkblocal (cib b1) (cib b2)
	|| (mkbnull) : d
        || (mkbsyn s d) : mkbsyn (cit s) (cit d)
        || (mkbclass c b) : mkbclass (cicl c) (cib b)
        || (mkbinstance t b ois) : mkbinstance (cii t) (cib b) (oap ff ois)
	|| (mkbdefault ts) : mkbdefault (map cit ts)
        || (mkbsign is t) : mkbsign (map ff is) (cit t)
	end
and cicl (mkcdecl aas a) = mkcdecl (map cia aas) (cia a)
and cia (mkassert i v) = mkassert (ff i) v
||  cia a = a
and cii (mkidecl aas ci ti vs) = mkidecl (map cia aas) (ff ci) (ff ti) vs
and cip (p, e) = (ci p, ci e)
and cif (spark is) = spark (map ff is)
||  cif (restr t) = restr (cit t)
||  cif f = f
and cit (mktcons i ts) = mktcons (ff i) (map cit ts)
||  cit (mktcontype ts t) = mktcontype (map cia ts) (cit t)
||  cit t = t
and cic (Cconstr s t ti n tbs) = Cconstr s (cit t) (citi ti) n (mapfst cit tbs)
and citi (mktinfo t n x y ats) = mktinfo (cit t) n x y (map ciat ats)
and ciat (mkcons i tbs) = mkcons (ff i) (mapfst cit tbs)
and cie (mkexpid i) = mkexpid (ff i)
||  cie (mkexpidall i) = mkexpidall (ff i)
||  cie (mkexpidsome i is) = mkexpidsome (ff i) is
||  cie (mkexpidmodall i) = mkexpidmodall (ff i)
)

-- Multiple definitions of the same original thing must get the same id-no
and mergedups xs =
    if AllowRedef then
	map (\x.(x,x)) xs
    else
        (concmap merge1 o group (\i1.\i2.id_orignames i1 = id_orignames i2) o sortx (\i1.\i2.id_orignames i1 < id_orignames i2)) xs
and merge1 [i] = [(i,i)]
||  merge1 (is as (i.is1)) = 
    let ri = reduce mostspec i is1 in
    map (\i.(i, ri)) is
-- keep the most specific info about an id
and mostspec i1 i2 & (id_visibility i1 = Vexported) = i1
||  mostspec i1 i2 & (id_visibility i2 = Vexported) = i2
||  mostspec (i1 as mkid _ _ (idi_type _ _ ti1 _ _) _)
             (i2 as mkid _ _ (idi_type _ _ ti2 _ _) _) = 
	 if get_no_of_constr_from_tinfo ti1 > get_no_of_constr_from_tinfo ti2 then i1 else i2
||  mostspec i _ = i

and sortx f l =
--    trace ("sort "@itos (length l)) 
    (sort f l)
end
