module -- mopt
--
-- Take care of some common cases in the mcode, which are not fixed in
-- the mcode generator.
--
#include "../mcode/mcodedef.t.t"
#include "../mcode/mutil1.t"
export mopt;
rec
    mnocom (Mcom _.M) = mnocom M
||  mnocom (m.M) = m.mnocom M
||  mnocom [] = []
and adj n (Sind m) = Sind (m-n)
||  adj n (Srel m) = Srel (m-n)
||  adj n a = a
and hadj n (hpind m) = hpind (m-n)
||  hadj n (hprel m) = hprel (m-n)
||  hadj n a = a
and mrev = mopcc o ccneg o mccop
and
    -- remove redundant load from stack
    mpeep ((m as Mmove (reg r1) pushS).Mmove (Sind 0) (reg r2).M) & (r1 = r2) =
	m.mpeep M
||  mpeep ((m as Mmove (reg r1) pushS).Mmove (Sind 0) a.M) =
	m.Mmove (reg r1) a.mpeep M
    -- improve address calculations
||  mpeep (Mmove (hprel 0) hp.M) = mpeep M
||  mpeep (Mmove (hprel 0) a.M) = Mmove hp a.mpeep M
||  mpeep (Mmove (Vrel 0) Vp.M) = mpeep M
||  mpeep (Mmove (Vrel 0) a.M) = Mmove Vp a.mpeep M
||  mpeep (Mmove (Srel 0) Sp.M) = mpeep M
||  mpeep (Mmove (Srel 0) a.M) = Mmove Sp a.mpeep M
||  mpeep (Mmove (regrel r 0) (reg r1).M) & (r = r1) = mpeep M
||  mpeep (Mmove (regrel r 0) a2.M) = Mmove (reg r) a2.mpeep M
    -- remove redundant jump
||  mpeep (Mjump l1.M as (Mlabel l2._)) & (l1 = l2) = mpeep M
    -- remove jump over jump that Gopt handles badly
||  mpeep (Mjcond cc l1.Mjump l2.M as (Mlabel l3._)) & (l1=l3) =
	Mjcond (mrev cc) l2.mpeep M
    -- improve returning a variable
||  mpeep (Mmove a (Sind n1).
	   Mmove (Srel n2) Sp.Mmove popS (reg r).M) & (n1=n2) =
	mpeep (Mmove a (reg r).Mmove (Srel(n2+1)) Sp.M)
    -- use autoincrement
||  mpeep (Mmove (Sind 0) a.Mmove (Srel 1) Sp.M) & (a~=pushS) =
	Mmove popS (adj 1 a).mpeep M
    -- improve ALLOC
||  mpeep ((m1 as Mmove (idlit _) tohp).
	   (m2 as Mmove (hprel 2) hp).
	   Mmove (hprel(-3)) a.M) & (a ~= tohp) =
		Mmove hp (hadj (-3) a).m1.m2.mpeep M
    -- rearrange moves to get better addressing modes
||  mpeep (Mmove a pushS.Mmove (Sind 0) (reg r).M) =
	Mmove a (reg r).Mmove (reg r) pushS.mpeep M
    -- all other cases
||  mpeep (m.M) = m.mpeep M
||  mpeep [] = []
and
    mopt = mpeep o mnocom
end
