/*
**	sort:		Sort a list.  Sorting is stable.
**			Has a few tricks to make it stable and avoid
**			concatenation.
*/
module
export sort;
rec sort lt l = qsort lt l []
-- qsort is a stable and does not concatenate.
and qsort lt [] r = r
||  qsort lt [x] r = x.r
||  qsort lt (x.xs) r = qpart lt x xs [] [] r
-- qpart partitions and sorts the sublists
and qpart lt x [] rlt rge r =
    -- rlt and rge are in reverse order and must be sorted with an
    -- anti-stable sorting
    rqsort lt rlt (x.rqsort lt rge r)
||  qpart lt x (y.ys) rlt rge r =
    if lt y x then
	qpart lt x ys (y.rlt) rge r
    else
	qpart lt x ys rlt (y.rge) r
-- rqsort is as qsort but anti-stable, i.e. reverses equal elements
and rqsort lt [] r = r
||  rqsort lt [x] r = x.r
||  rqsort lt (x.xs) r = rqpart lt x xs [] [] r
and rqpart lt x [] rle rgt r =
    qsort lt rle (x.qsort lt rgt r)
||  rqpart lt x (y.ys) rle rgt r =
    if lt x y then
	rqpart lt x ys rle (y.rgt) r
    else
	rqpart lt x ys (y.rle) rgt r
end
