module -- mprint
-- print mcode
#include "mcodedef.t.t"
export mprint;
rec
    preg n		= 'r'.itos n
and pamode Vp		= "Vp"
||  pamode (Vind n)	= itos n@"(Vp)"
||  pamode (Vrel n)	= '$'.itos n@"(Vp)"
||  pamode pushV	= "Vpush"
||  pamode popV		= "Vpop"
||  pamode Sp		= "Sp"
||  pamode (Sind n)	= itos n@"(Sp)"
||  pamode (Srel n)	= '$'.itos n@"(Sp)"
||  pamode pushS	= "Spush"
||  pamode popS		= "Spop"
||  pamode (reg n)	= preg n
||  pamode (regind n m)	= itos m@"("@preg n@")"
||  pamode (regrel n m)	= '$'.itos m@"("@preg n@")"
||  pamode hp		= "Hp"
||  pamode (hpind n)	= itos n@"(Hp)"
||  pamode (hprel n)	= '$'.itos n@"(Hp)"
||  pamode tohp		= "toH"
||  pamode (glob s)	= s
||  pamode (idlit s)	= '$'.s
||  pamode (retaddr s)	= '#'.s
||  pamode (const n)	= '$'.itos n


and ptag oeval		= "oeval"
||  ptag ounwind	= "ounwind"
||  ptag ojfun		= "ojfun"
||  ptag omkapl		= "omkapl"
||  ptag ogettag	= "ogettag"
||  ptag ogc		= "ogc"
||  ptag ocmp		= "ocmp"
||  ptag oprint		= "oprint"
||  ptag ospark		= "ospark"
||  ptag onb		= "onb"
||  ptag onp		= "onp"
||  ptag oargs		= "oargs"
||  ptag ovno		= "ovno"
and pcc eq		= "eq"
||  pcc ne		= "ne"
||  pcc lt		= "lt"
||  pcc gt		= "gt"
||  pcc le		= "le"
||  pcc ge		= "ge"
||  pcc ltstack		= "lts"
||  pcc ltheap		= "lth"
||  pcc gtstack		= "gts"
||  pcc geheap		= "geh"
and pop add		= "add"
||  pop sub		= "sub"
||  pop mul		= "mul"
||  pop div		= "div"
||  pop mod		= "mod"

and mp (Mmove a1 a2)	= conc ["\tmove\t";pamode a1;",";pamode a2]
||  mp (Mcall s)	= "\tcall\t"@s
||  mp (Mjumpf s)	= "\tjumpf\t"@s
||  mp (Mjump s)	= "\tjump\t"@s
||  mp (Mjumpind a)	= "\tjumpind\t"@pamode a
||  mp (Mcallind a)	= "\tcallind\t"@pamode a
||  mp (Mcase a l h m ls _)= conc ["\tcase\t"; pamode a; ","; itos l; ","; itos h; ","; itos m; " "] @ concmap (\l.","@l) ls
||  mp (Mboolcc cc a) = conc ["\tboolcc\t"; pcc cc; ","; pamode a]
||  mp Mreturn		= "\treturn"
||  mp (Mcalltag t n)	= conc ["\tcall\t";ptag t;"(";preg n;")"]
||  mp (Mjumptag t n)	= conc ["\tjump\t";ptag t;"(";preg n;")"]
||  mp (Mjcond cc s)	= conc ["\tj";pcc cc;"\t";s]
||  mp (Mlabel s)	= s@":"
||  mp (Mcompare a1 a2)	= conc ["\tcomp\t";pamode a1;",";pamode a2]
||  mp (Mop2 p a1 a2)	= conc ["\t";pop p;"2\t";pamode a1;",";pamode a2]
||  mp (Mop3 p a1 a2 a3)= conc ["\t";pop p;"3\t";pamode a1;",";pamode a2;",";pamode a3]

||  mp Mdata		= "\t.data"
||  mp Mtext		= "\t.text"
||  mp (Mword a)	= "\t.word\t"@pamode a
||  mp (Mstring s)	= "\t.string\t\""@s@"\""
||  mp (Mfloat s)	= "\t.float\t"@s
||  mp (Mexport s)	= "\t.export\t"@s
||  mp (Mfunbegin s)	= "\t.funbegin\t"@s
||  mp Mfunend		= "\t.funend"

||  mp Malign		= "\t.malign"
||  mp (Mcom s)		= '#'.' '.s
||  mp (Masm s l)	= "\t.asm\t\""@s@"\","@mix (map pamode l) ","

and mprint l		= concmap (\m.mp m@"\n") l
end
