module
#include "mcodedef.t.t"
#include "../Gcode/Gcodedef.t.t"
#include "Wuse.t"
#include "mutil.t"
#include "mutil1.t"
#include "mregs.t"
#include "mstrlbl.t"
#include "mstrid.t"
#include "handmade.mcode.t"
#include "../misc/setofid.t"
#include "../misc/flags.t"
#include "mmemcheck.t"
export mfunstart, mfunend, msfunstart;
rec
mfunstart t G i n =
	let (c, d, uv, us, k) = mmemcheck t G allpopV allpopS  in
	let sn = itos n in
	let ifunname = mstrid i in
	let bexp = mexported i in
	let exp s = if bexp then [Mexport s] else [] in
	let rd = difference (mkset d) [ifunname] in
	(
	Mcom ("FUNSTART "@ifunname@" "@sn).
	Mdata .					-- FUN and info in data segment
	Malign .				-- on word boundary
	exp ifunname @				-- possible global label
    Mlabel ifunname .				-- local label
	(if n = 0 then
		-- Zero:ary function, i.e. global value definition.
		[
		Mword (glob ("VAP"));		-- VAP tag
		Mword (glob ("V"@ifunname));	-- function part
		Mword (const 0)			-- filler
		]
	else
		[
		Mword (glob ("FUN"));		-- FUN tag
		Mword (glob ("V"@ifunname))	-- pointer to info vector
		]
	)
	@
		exp ("V"@ifunname) @
		Mword (glob ("S"@sn@ifunname)).	-- function call entry		SHOULD BE BELOW, but backward compat staops that!!
	Mlabel ("V"@ifunname) .			-- Function info vector:
		Mword (const n).		-- arity
		Mword (glob (ifunname)).	-- function node pointer
		Mword (glob ("unw"@itos n)).	-- unwind code
		Mword (glob ("J"@sn@ifunname)).	-- function code
		Mword (glob ("vunw"@itos n)).	-- unwind of vector apply
		Mword (if Stingy then (glob ("Y"@sn@ifunname)) else (const 0)). -- stingy code
		Mword (const 0) .		-- gc unmark chain
		Mword (const (length rd)).	-- # of refs
		map (Mword o glob) rd @		-- refs
		Mtext .				-- text segment again
		exp ("S"@sn@ifunname) @		-- possible global call label
	Mlabel ("S"@sn@ifunname).		-- local call label
		Mmove (Srel(n+1)) pushV.	-- adjust and push sp
		exp ("J"@sn@ifunname) @		-- possible global jump label
	Mlabel ("J"@sn@ifunname).		-- local jump label
		Mfunbegin ifunname.
		(if Profile then profcode ("PC"@sn@ifunname) else []) @
		(if Parallel then gcsynch ("GC"@sn@ifunname) else []) @ 
		(if EnterHole then [Mmove (idlit "HOLE") (Sind n)] else []) @
		c, [], [], [], 0)

and
    gcsynch l = [Mcompare (glob "_wantgc") (const 0);
		 Mjcond eq l;
		 Mcall "GC_synch";
		 Mlabel l]
and
-- Mcount makes a call to mcount (in runtime.M).
    profcode l =[
		 Mmove (idlit l) (reg 0);
		 Mcall "Mcount";
		 Mdata;
		 Mlabel l;
		 Mword (const 0);
		 Mtext;
		 Mcall "Mcountpost"]
and
    mfunend t g G V S =
	let (c, d, v, s, k) = M t g G V S
	in (Mcom "FUNEND".Mfunend.c, [], v, s, k)
and
    msfunstart t G i n =
	let (c, d, uv, us, k) = mmemcheck t G allpopV allpopS  in
	let ifunname = "Y"@itos n@mstrid i in
	((if mexported i then [Mexport ifunname; Mlabel ifunname]
	  else [Mlabel ifunname])@Mmove (Srel(n+1)) pushV.c, [], [], [], 0)
end
