module
#include "../mcode/mcodedef.t.t"
#include "../mcode/mprint.t"
#include "../misc/flags.t"
#include "mtrans1.t"
#include "mtrans2.t"
#include "tmp.h"

-- Registers:
-- r0-r7	%l0-%l7
-- r8-r15	%i0-%i7	i6=fp
-- r16-r23	%o0-%o7	o6=sp o7=retaddr
-- r24-r31	%g0-%g7
-- r0-r4 Mcode
-- r5 Vp
-- r6 Sp
-- r7 hp
-- r8 indreg
-- r9-r11 Mcode
-- r12 tmp
-- r13 ehp
-- r14 fp
-- r15 old ra
-- r16-r17 mul/div/rem
-- r18-r21 ?
-- r22 sp
-- r23 ra
-- r24 0
-- r25-29 tmp
-- r30 ?
-- r31 ?
export assemblercode, Aregs, Dregs, usecase, use3op,
	argcreg, tagreg, bigeqreg, indreg;
rec
    Aregs = [1;2;3;4;9;10;11] @ fail "Out of A-regs"
and Dregs = [1;2;3;4;9;10;11] @ fail "Out of D-regs"
and usecase max low high cnt = cnt>=4 & (high-low)<cnt*5
and use3op = true
and argcreg = reg 2
and tagreg  = reg 2
and bigeqreg= reg 2
and indreg  = reg 8
and regname n = 
	if n < 8 then
		"%l"@itos n
	else if n < 16 then
		"%i"@itos (n-8)
	else if n < 24 then
		"%o"@itos (n-16)
	else if n < 32 then
		"%g"@itos (n-24)
	else
		fail ("Bad reg "@itos n)
and amode (const 0) = "%g0"
||  amode x = amode0 x
and amode0 (reg i)      = regname i
 || amode0 (regind r i) = "[" @ regname r @ "+" @ itos (i*4) @ "]" 
 || amode0 (regrel _ _) = fail "amode regrel\n"

 || amode0 (glob i)  = i
 || amode0 (idlit s) = s
 || amode0 (const n) = itos n
and aspr ""       ams      = ""
||  aspr ('^'.cs) (am.ams) = amode0 am @ aspr cs ams
||  aspr ('~'.cs) (regind r i.ams) = amode0 (regind r (i+1)) @ aspr cs ams
||  aspr ('~'.cs) (am.ams) = amode0 am @ aspr cs ams
||  aspr (c.cs)   ams      = c.aspr cs ams

and isreg (reg _) = true
 || isreg _       = false
and otag oeval   = "0"
 || otag ounwind = "4"
 || otag ojfun   = "8"
 || otag omkapl  = "12"
 || otag ogettag = "16"
 || otag ogc     = "20"
 || otag ocmp    = "24"
 || otag oprint  = "28"
 || otag ospark  = "32"
and ccname eq = "e"
 || ccname ne = "ne"
 || ccname lt = "l"
 || ccname gt = "g"
 || ccname le = "le"
 || ccname ge = "ge"
 || ccname ltstack = "lu"
 || ccname ltheap = "lu"
 || ccname gtstack = "gu"
 || ccname geheap = "geu"
and opname add = "add"
||  opname sub = "sub"
||  opname mul = "mul"
||  opname div = "div"
||  opname mod = "rem"
and amode1 s a1 = '\t'.s@'\t'.amode a1@"\n"
and amode2 s a1 a2 = '\t'.s@'\t'.amode a1@","@amode a2@"\n"
and amode3 s a1 a2 a3 = '\t'.s@'\t'.amode a1@","@amode a2@","@amode a3@"\n"
and oneop s1 s2 = '\t'.s1@'\t'.s2@"\n"
and saveret = ins /*extra space allocated by previous transformation */(Mmove (reg Ret) (regind Vpr 0))
and dtmp = dtmp4
and gtmp = dtmp4
and adtmp = amode dtmp
and agtmp = amode gtmp
and adtmp1 = amode dtmp1
and mtmp0 = reg 16
and mtmp1 = reg 17
and nop = "\tnop\n"
and ldglob a1 a2 = "\tsethi\t%hi("@amode a2@"),"@agtmp@"\n\tld\t["@agtmp@"+%lo("@amode a2@")],"@amode a1@"\n"
and stglob a1 a2 = "\tsethi\t%hi("@amode a2@"),"@agtmp@"\n\tst\t"@amode a1@",["@agtmp@"+%lo("@amode a2@")]\n"
#define CLIM 128	/* later 4096 */
and
    ins (Mmove (r1 as reg _) (r2 as reg _)) = 
	amode2 "mov" r1 r2
||  ins (Mmove (a1 as reg _) (a2 as regind _ _)) =
	amode2 "st" a1 a2
||  ins (Mmove (a1 as regind _ _) (a2 as reg _)) =
	amode2 "ld" a1 a2
||  ins (Mmove (a1 as const n) (a2 as reg _)) & (n < CLIM & n >=-CLIM) =
	amode2 "mov" a1 a2
||  ins (Mmove (a1 as const _) (a2 as reg _)) =
	amode2 "set" a1 a2
||  ins (Mmove (a1 as idlit _) (a2 as reg _)) =
	amode2 "set" a1 a2
||  ins (Mmove (a1 as reg _) (a2 as glob _)) =
	stglob a1 a2
||  ins (Mmove (a1 as glob _) (a2 as reg _)) =
	ldglob a2 a1
||  ins (Mop2 op a1 a2) = ins (Mop3 op a1 a2 a2)
||  ins (Mop3 op a1 a2 a3) & (op = add | op = sub) =
	amode3 (opname op) a2 a1 a3
||  ins (Mop3 op a1 a2 a3) =
	ins (Mmove a2 mtmp0) @
	ins (Mmove a1 mtmp1) @
	"\tmov\t%o7,%i4\n"@
	"\tcall\t."@opname op@",2\n"@nop@
	"\tmov\t%i4,%o7\n"@
	ins (Mmove mtmp0 a3)
||  ins (Mcompare a1 a2) =
	amode2 "cmp" a1 a2

||  ins (Mcall s) = saveret @ oneop "call" s @ nop
||  ins (Mjumpf s) = ins (Mmove (idlit s) gtmp)@oneop "jmp" agtmp @ nop
||  ins (Mjump s) = oneop "b" s @ nop

||  ins Mreturn = concmap ins 
	[Mmove (reg Ret) dtmp;
	 Mmove (regind Vpr 0) (reg Ret);
	 Mop2 add (const 4) (reg Vpr)] @ 
	"\tjmpl\t" @ adtmp @ "+8,%g0\n" @ nop

||  ins (m as Mjcond cc l) = "\tb"@ccname cc@"\t"@l@"\n"@nop
||  ins (m as Mboolcc cc a) =
	"\tb"@ccname cc@"\t1f\n"@
	"\tmov\t1,"@amode a@"\n"@
	"\tmov\t0,"@amode a@"\n"@
	"1:\n"

||  ins (m as Mcalltag t r) = saveret@"\tld\t["@regname r@"+"@otag t@"],"@adtmp@"\n\tcall\t"@adtmp@"\n" @ nop
||  ins (m as Mjumptag t r) = 
  "\tld\t["@regname r@"+"@otag t@"],"@adtmp@"\n\tjmp\t"@adtmp@"\n" @ nop

 || ins (Mcase a l h _ ls x) =
 	let t = 'L'.itos x in
 	ins (Mmove a dtmp) @
	(if l = 0 then "" else ins (Mop2 sub (const l) dtmp))@
	ins (Mcompare dtmp (const (h-l))) @
	"\tbgu\t"@t@"_2\n"@nop@
	"\tsll\t"@adtmp@",2,"@adtmp@"\n"@
	"\tset\t"@t@"_1,"@adtmp1@"\n"@
	"\tld\t["@adtmp@"+"@adtmp1@"],"@adtmp@"\n"@
	"\tjmp\t"@adtmp@"\n"@nop@
	t@"_1:\n"@
	concmap (\l."\t.word\t"@l@"\n") ls@
	t@"_2:\n"

 || ins (Mdata) = "\t.data\n"
 || ins (Mtext) = "\t.text\n"
 || ins (Mword (glob  a)) = "\t.word\t" @ a @ "\n"
 || ins (Mword (idlit a)) = "\t.word\t" @ a @ "\n"
 || ins (Mword (const i)) = "\t.word\t" @ itos i @ "\n"
 -- Printing floats is a hack!
 || ins (Mfloat s) = "\t.word\t"@fmtf "\t0x%08x,0x%08x" (stof s)@"\n"
 || ins (Mstring s) = itlist (\x.\p.
 				  "\t.byte\t" @ itos(ord x)@"\n"@p) s 
				 ("\t.byte\t0\n\t.align\t4\n")
 				
 || ins (Mexport a) = "\t.global\t" @ a @ "\n"
 || ins (Mcom s) = " ! " @ s @ "\n"
 || ins (Mlabel l) = l @ ":\n"
 || ins (Masm s l) = aspr s l @ "\n"
 || ins (Malign) = "\t.align\t4\n"
 || ins (Mfunbegin _) = ""
 || ins (Mfunend ) = ""
 || ins m = " ??"@mprint[m]@"\n" --fail ("ins: strange Mcode " @ mprint [m])
and prol = ""

and assemblercode m =
--	let mt1 = mtrans1 m
--	in let mt = mtrans2 mt1 in
--	mprint mt1 @ mprint mt @
    let mt = mtrans2 (mtrans1 m) in
    (if PrMtrans then
	mprint mt
    else
	"") @
    prol @
    concmap ins mt
end
