module
#include "../mcode/mcodedef.t.t"
#include "../mcode/mprint.t"
#include "../misc/flags.t"
#include "mtrans1.t"
#include "mtrans2.t"
#include "ds2ip.t"
#include "tmp.h"

-- To do:
-- negation via negu
-- avoid checking against upper limit in case if complete
-- use gp more (what constants should go into gp area?)

-- Registers:

export assemblercode, Aregs, Dregs, usecase, use3op,
	argcreg, tagreg, bigeqreg, indreg;
rec
    Aregs = count 1 13 @ fail "Out of A-regs"
and Dregs = count 1 13 @ fail "Out of D-regs"
and usecase max low high cnt =  cnt>=4 & (high-low)<cnt*5
and use3op = true
and argcreg = reg 2
and tagreg  = reg 2
and bigeqreg= reg 2
and indreg  = reg 31		-- (real r7)
and regname n = "$"@itos ((n+8)%32)
and amode (reg i)      = regname i
 || amode (regind r i) = itos (i*4) @ "(" @ regname r @ ")"
 || amode (regrel _ _) = fail "amode regrel\n"

 || amode (glob i)  = drop_ i
 || amode (idlit s) = drop_ s
 || amode (const n) = itos n
and drop_ ('_'.s) = s
||  drop_ s = s
and aspr ""       ams      = ""
||  aspr ('^'.cs) (am.ams) = amode am @ (aspr cs ams)
||  aspr (c.cs)   ams      = c.aspr cs ams

and isreg (reg _) = true
 || isreg _       = false
and otag oeval   = "0"
 || otag ounwind = "4"
 || otag ojfun   = "8"
 || otag omkapl  = "12"
 || otag ogettag = "16"
 || otag ogc     = "20"
 || otag ocmp    = "24"
 || otag oprint  = "28"
 || otag ospark  = "32"
and ccname eq = "eq"
 || ccname ne = "ne"
 || ccname lt = "lt"
 || ccname gt = "gt"
 || ccname le = "le"
 || ccname ge = "ge"
 || ccname ltstack = "ltu"
 || ccname ltheap = "ltu"
 || ccname gtstack = "gtu"
 || ccname geheap = "geu"
and opname add = "addu"
||  opname sub = "subu"
||  opname mul = "mul"
||  opname div = "div"
||  opname mod = "rem"
and amode1 s a1 = '\t'.s@'\t'.amode a1@"\n"
and amode2 s a1 a2 = '\t'.s@'\t'.amode a1@","@amode a2@"\n"
and amode3 s a1 a2 a3 = '\t'.s@'\t'.amode a1@","@amode a2@","@amode a3@"\n"
and oneop s1 s2 = '\t'.s1@'\t'.s2@"\n"
and saveret = ins /*extra space allocated by previous transformation */(Mmove (reg Ret) (regind Vpr 0))
and dtmp = dtmp4
and adtmp = amode dtmp
and
    ins (Mmove (r1 as reg _) (r2 as reg _)) = 
	amode2 "move" r2 r1
||  ins (Mmove (a1 as reg _) (a2 as regind _ _)) =
	amode2 "sw" a1 a2
||  ins (Mmove (a1 as regind _ _) (a2 as reg _)) =
	amode2 "lw" a2 a1
||  ins (Mmove (a1 as const _) (a2 as reg _)) =
	amode2 "li" a2 a1
||  ins (Mmove (a1 as idlit _) (a2 as reg _)) =
	amode2 "la" a2 a1
||  ins (Mmove (a1 as reg _) (a2 as glob _)) =
	amode2 "sw" a1 a2
||  ins (Mmove (a1 as glob _) (a2 as reg _)) =
	amode2 "lw" a2 a1
||  ins (Mop2 op (a1 as const _) (a2 as reg _)) =
	amode2 (opname op) a2 a1
||  ins (Mop2 op a1 a2) =
	amode3 (opname op) a2 a2 a1
||  ins (Mop3 sub a1 (const 0) a3) =
	amode2 "negu" a3 a1
||  ins (Mop3 op a1 a2 a3) =
	amode3 (opname op) a3 a2 a1

||  ins (Mcall s) = saveret @ oneop "jal" s
||  ins (Mjumpf s) = oneop "j" s
||  ins (Mjump s) = oneop "b" s

||  ins Mreturn = concmap ins 
	[Mmove (reg Ret) dtmp;
	 Mmove (regind Vpr 0) (reg Ret);
	 Mop2 add (const 4) (reg Vpr)] @ amode1 "j" dtmp

||  ins (m as Mcompare _ _) = "!!! Bad "@mprint[m]
||  ins (m as Mjcond _ _) = "!!! Bad "@mprint[m]
||  ins (m as Mboolcc _ _) = "!!! Bad "@mprint[m]

||  ins (m as Mcalltag t r) = saveret@"\tlw\t"@adtmp@","@otag t@"("@regname r@")\n\tjal\t"@adtmp@"\n"
||  ins (m as Mjumptag t r) = 
  "\tlw\t"@adtmp@","@otag t@"("@regname r@")\n\tj\t"@adtmp@"\n"

 || ins (Mcase a l h _ ls x) =
 	let t = 'L'.itos x in
	"\t.rdata\n"@t@"_1:\n"@
	concmap (\l."\t.word\t"@l@"\n") ls@
	"\t.text\n"@
 	ins (Mmove a dtmp) @
	(if l = 0 then "" else ins (Mop2 sub (const l) dtmp))@
	"\tbgtu\t"@adtmp@","@itos(h-l)@","@t@"_2\n"@
	"\tsll\t"@adtmp@","@adtmp@",2\n"@
	"\tlw\t"@adtmp@","@t@"_1("@adtmp@")\n"@
	"\tj\t"@adtmp@"\n"@
	t@"_2:\n"

 || ins (Mdata) = "\t.data\n"
 || ins (Mtext) = "\t.text\n"
 || ins (Mword (glob  a)) = "\t.word\t" @ drop_ a @ " : 1\n"
 || ins (Mword (idlit a)) = "\t.word\t" @ drop_ a @ " : 1\n"
 || ins (Mword (const i)) = "\t.word\t" @ itos i @ " : 1\n"
-- || ins (Mfloat s) = "\t.double\t"@s@" : 1\n"
 || ins (Mfloat s) = let (x,y) = ds2ip s in ins (Mword (const x)) @ ins (Mword (const y))
 || ins (Mstring s) = itlist (\x.\p.
 				  "\t.byte\t" @ itos(ord x)@"\n"@p) s 
				 ("\t.byte\t0\n\t.align\t2\n")
 				
 || ins (Mexport a) = "\t.globl\t" @ drop_ a @ "\n"
 || ins (Mcom s) = " # " @ s @ "\n"
 || ins (Mlabel l) = drop_ l @ ":\n"
 || ins (Masm s l) = aspr s l @ "\n"
 || ins (Malign) = "\t.align\t2\n"
 || ins (Mfunbegin _) = ""
 || ins (Mfunend ) = ""
 || ins m = " #"@mprint[m]@"\n" --fail ("ins: strange Mcode " @ mprint [m])
and cmptr [] = []
||  cmptr (Mcompare a1 a2.Mjcond cc s.ms) =
	Masm ("\tb"@ccname cc@"\t^,^,^") [a1; a2; (glob s)].cmptr ms
||  cmptr (Mcompare a1 a2.Mboolcc cc a3.ms) =
	Masm ("\ts"@ccname cc@"\t^,^,^") [a3; a1; a2].cmptr ms
||  cmptr (m.ms) = m.cmptr ms
and prol = concmap (\s."\t.extern\t"@s@" 4\n") [
"INT";"CHAR";"TAG";"TAG0";"VEK";"HOLE";"AP";"CAP";"VAP";"PAIR0";"PAIR1";"PAIR2";"PAIR3";"PAIR4";"CANON"]

and assemblercode m =
--	let mt1 = mtrans1 m
--	in let mt = mtrans2 mt1 in
--	mprint mt1 @ mprint mt @
    let mt = cmptr (mtrans2 (mtrans1 m)) in
    (if PrMtrans then
	mprint mt
    else
	"") @
    prol @
    concmap ins mt
end
