module -- mtrans
--
-- remove all popS, popV, tohp
--
#include "../mcode/mcodedef.t.t"
#include "../mcode/mutil1.t"
#include "tmp.h"
export mtrans1;
rec
    srel 0 = Sp
||  srel n = Srel n
and hrel 0 = hp
||  hrel n = hprel n
and vrel 0 = Vp
||  vrel n = Vrel n
and adj (_,_,V) Vp       = vrel V
||  adj (_,_,V) (Vrel n) = vrel (V+n)
||  adj (_,_,V) (Vind n) = Vind (V+n)
||  adj (_,_,V) pushV    = Vind (V-1)
||  adj (_,_,V) popV     = Vind V
||  adj (_,S,_) Sp       = srel S
||  adj (_,S,_) (Srel n) = srel (S+n)
||  adj (_,S,_) (Sind n) = Sind (S+n)
||  adj (_,S,_) pushS    = Sind (S-1)
||  adj (_,S,_) popS     = Sind S
||  adj (H,_,_) hp       = hrel H
||  adj (H,_,_) (hprel n)= hrel (H+n)
||  adj (H,_,_) (hpind n)= hpind (H+n)
||  adj (H,_,_) tohp     = hpind H
||  adj _     a        = a
and chg (H,S,V) pushV    = (H,S,V-1)
||  chg (H,S,V) popV     = (H,S,V+1)
||  chg (H,S,V) pushS    = (H,S-1,V)
||  chg (H,S,V) popS     = (H,S+1,V)
||  chg (H,S,V) tohp     = (H+1,S,V)
||  chg HSV     _        = HSV

and nonseq (Mcall _)	= true
||  nonseq Mreturn	= true
||  nonseq (Mcalltag _ _) = true
||  nonseq (Mjumptag _ _) = true
||  nonseq (Mjump _)	= true
||  nonseq (Mjumpf _)	= true
||  nonseq (Mjcond _ _) = true
||  nonseq (Mlabel _)	= true
||  nonseq (Mcase _ _ _ _ _ _) = true
||  nonseq (Masm _ _)	= true		-- safe assumption
||  nonseq _		= false

and flush (H,S,V) = (flh H @ fls S @ flv V
			where flh 0 = []
			   || flh n = [Mmove (hprel n) hp]
			and   fls 0 = []
			   || fls n = [Mmove (Srel n) Sp]
			and   flv 0 = []
			   || flv n = [Mmove (Vrel n) Vp])

and mskip HSV (Mtext.ms) = Mtext.mt HSV ms
||  mskip HSV     (m.ms) =     m.mskip HSV ms
||  mskip HSV     []     = []
and -- Must know if label is in text or data-segment
   ml (Mlabel s.l) c = Mlabel (c.s). ml l c
|| ml (Mdata.l)    c = Mdata. ml l 'W'
|| ml (Mtext.l)    c = Mtext. ml l 'P'
|| ml (m.l)        c = m.ml l c
|| ml [] _           = []
-- Make constans second operand
and mc (Mcompare (a1 as const _) a2.ms) = Mcompare a2 a1. invj ms
||  mc (m.ms) = m.mc ms
||  mc [] = []
and invj (Mjcond cc l.ms) = Mjcond (mopcc (ccrev (mccop cc))) l. mc ms
||  invj (Mboolcc cc l.ms) = Mboolcc (mopcc (ccrev (mccop cc))) l. mc ms
||  invj (m.ms) = m . invj ms
||  invj [] = []
and
    mt _ [] = []
||  mt (H,S,V) (Mmove (Vrel n) Vp.ms) = mt (H, S,V+n) ms
||  mt (H,S,V) (Mmove (Srel n) Sp.ms) = mt (H, S+n,V) ms
||  mt (H,S,V) (Mmove (hprel n) hp.ms) = mt (H+n, S,V) ms
||  mt HSV (Mmove a1 Vp.ms) = 
	let (H',S',_) = chg HSV a1 in
	Mmove (adj HSV a1) Vp .mt (H',S',0) ms
||  mt HSV (Mmove a1 Sp.ms) = 
	let (H',_,V') = chg HSV a1 in
	Mmove (adj HSV a1) Sp .mt (H',0,V') ms
||  mt HSV (Mmove a1 a2.ms) =
	let HSV' = chg HSV a1 in
	Mmove (adj HSV a1) (adj HSV' a2) .mt (chg HSV' a2) ms

||  mt HSV (Mcompare a1 a2.ms) =
	flush HSV @ let HSV = (0,0,0) in
	let HSV' = chg (0,0,0) a1 in
	Mcompare (adj HSV a1) (adj HSV' a2) .mt (chg HSV' a2) ms
||  mt HSV (Mop2 op a1 a2.ms) =
	let HSV'  = chg HSV  a1 in
	Mop2 op (adj HSV a1) (adj HSV' a2) .mt (chg HSV' a2) ms
||  mt HSV (Mop3 op a1 a2 a3.ms) =
	let HSV'  = chg HSV  a1 in
	let HSV'' = chg HSV' a2 in
	Mop3 op (adj HSV a1) (adj HSV' a2) (adj HSV'' a3) .mt (chg HSV'' a3) ms
||  mt HSV (Mboolcc cc a.ms) = 
	Mboolcc cc (adj HSV a) .mt (chg HSV a) ms
||  mt HSV (Mdata.ms) = Mdata .mskip HSV ms
||  mt HSV (m.ms) & (nonseq m) = flush (mx m HSV) @ m.mt (0,0,0) ms
||  mt HSV (m.ms) = m.mt HSV ms

-- extra word for call
and mx (Mcalltag _ _) (H,S,V) = (H,S,V-1)
||  mx (Mcall _) (H,S,V) = (H,S,V-1)
||  mx m HSV = HSV

and mv [] = []
||  mv (Mop3 op popV a2 a3.ms) = Mmove popV dtmp4.mv (Mop3 op dtmp4 a2 a3.ms)
||  mv (Mop3 op a1 popV pushV.ms) = Mop3 op a1 (Vind 0) (Vind 0).mv ms
||  mv (Mop3 op a1 a2 pushV.ms) = Mmove (const 0) pushV.mv (Mop3 op a1 a2 (Vind 0).ms)
||  mv (Mop3 op a1 popV a3.ms) =
		Mmove popV dtmp4.mv (Mop3 op a1 dtmp4 a3.ms)
||  mv (Mop2 op popV a2.ms) = Mmove popV dtmp4.mv (Mop2 op dtmp4 a2.ms)

||  mv (Mcompare popV a2.ms) = Mmove popV dtmp4.mv (Mcompare dtmp4 a2.ms)
||  mv (Mcompare a1 popV.ms) = Mmove popV dtmp4.mv (Mcompare a1 dtmp4.ms)
||  mv (m.ms) = m.mv ms

and mka Vp = (reg Vpr)
||  mka Sp = (reg Spr)
||  mka hp = (reg hpr)
||  mka (Vind n) = (regind Vpr n)
||  mka (Sind n) = (regind Spr n)
||  mka (hpind n) = (regind hpr n)
||  mka (Vrel n) = (regrel Vpr n)
||  mka (Srel n) = (regrel Spr n)
||  mka (hprel n) = (regrel hpr n)
||  mka a  = a

-- Remove special regs
and mk (Mmove a1 a2) = Mmove (mka a1) (mka a2)
||  mk (Mcompare a1 a2) = Mcompare (mka a1) (mka a2)
||  mk (Mop2 op a1 a2) = Mop2 op (mka a1) (mka a2)
||  mk (Mop3 op a1 a2 a3) = Mop3 op (mka a1) (mka a2) (mka a3)
||  mk (Mcase a x1 x2 x3 x4 x5) = Mcase (mka a) x1 x2 x3 x4 x5
||  mk (Mboolcc cc a) = Mboolcc cc (mka a)
||  mk (Masm s ass) = Masm s (map mka ass)
||  mk m = m
and mtrans1 ms = map mk (mt (0,0,0) (mc (mv ms)))
end
