module -- mtrans
--
-- remove all popS, pushS, tohp because 80386 can't use them
-- remove popV, pushV from everything but moves
--
#include "../mcode/mcodedef.t.t"
#include "../mcode/mutil1.t"
export mtrans;
rec
    srel 0 = Sp
||  srel n = Srel n
and hrel 0 = hp
||  hrel n = hprel n
and adj (_,S) Sp       = srel S
||  adj (_,S) (Srel n) = srel (S+n)
||  adj (_,S) (Sind n) = Sind (S+n)
||  adj (_,S) pushS    = Sind (S-1)
||  adj (_,S) popS     = Sind S
||  adj (H,_) hp       = hrel H
||  adj (H,_) (hprel n)= hrel (H+n)
||  adj (H,_) (hpind n)= hpind (H+n)
||  adj (H,_) tohp     = hpind H
||  adj _     a        = a
and chg (H,S) pushS    = (H,S-1)
||  chg (H,S) popS     = (H,S+1)
||  chg (H,S) tohp     = (H+1,S)
||  chg HS    _        = HS

and nonseq (Mcall _)	= true
||  nonseq Mreturn	= true
||  nonseq (Mcalltag _ _) = true
||  nonseq (Mjumptag _ _) = true
||  nonseq (Mjump _)	= true
||  nonseq (Mjumpf _)	= true
||  nonseq (Mjcond _ _) = true
||  nonseq (Mlabel _)	= true
||  nonseq (Mcase _ _ _ _ _ _) = true
||  nonseq (Masm _ _)	= true		-- safe assumption
||  nonseq _		= false

and flush (H,S) = (flh H @ fls S
			where flh 0 = []
			   || flh n = [Mmove (hprel n) hp]
			and   fls 0 = []
			   || fls n = [Mmove (Srel n) Sp])

and mskip HS (Mtext.ms) = Mtext.mt HS ms
||  mskip HS     (m.ms) =     m.mskip HS ms
and
    mt _ [] = []
||  mt (H,S) (Mmove (Srel n) Sp.ms) = mt (H, S+n) ms
||  mt (H,S) (Mmove (hprel n) hp.ms) = mt (H+n, S) ms
||  mt (H,S) (Mmove a1 Sp.ms) = Mmove (adj (H,S) a1) Sp .mt (H,0) ms
||  mt HS (Mmove a1 a2.ms) =
	let HS' = chg HS a1 in
	Mmove (adj HS a1) (adj HS' a2) .mt (chg HS' a2) ms
||  mt HS (Mcompare a1 a2.ms) =
	let HS' = chg HS a1 in
	Mcompare (adj HS a1) (adj HS' a2) .mt (chg HS' a2) ms
||  mt HS (Mop2 op a1 a2.ms) =
	let HS'  = chg HS  a1 in
	Mop2 op (adj HS a1) (adj HS' a2) .mt (chg HS' a2) ms
||  mt HS (Mop3 op a1 a2 a3.ms) =
	let HS'  = chg HS  a1 in
	let HS'' = chg HS' a2 in
	Mop3 op (adj HS a1) (adj HS' a2) (adj HS'' a3) .mt (chg HS'' a3) ms
||  mt HS (Mboolcc cc a.ms) = 
	Mboolcc cc (adj HS a) .mt (chg HS a) ms
||  mt HS (Mdata.ms) = Mdata .mskip HS ms
||  mt HS (m.ms) & (nonseq m) = flush HS @ m.mt (0,0) ms
||  mt HS (m.ms) = m.mt HS ms
and dtmp1 = glob "dtmp1"
and dtmp2 = glob "dtmp2"
and conflict (regind r1 _) (reg r2) = r1 = r2
||  conflict a1            a2       = a1 = a2
and mv [] = []
||  mv (Mop3 op popV a2 a3.ms) = Mmove popV dtmp1.mv (Mop3 op dtmp1 a2 a3.ms)
||  mv (Mop3 op a1 popV pushV.ms) = Mop3 op a1 (Vind 0) (Vind 0).mv ms
||  mv (Mop3 op a1 a2 pushV.ms) = Mmove (const 0) pushV.mv (Mop3 op a1 a2 (Vind 0).ms)
||  mv (Mop3 op a1 popV a3.ms) =
	if ~ conflict a1 a3 then
		Mmove popV a3. Mop3 op a1 a3 a3. mv ms
	else
		Mmove popV dtmp2.mv (Mop3 op a1 dtmp2 a3.ms)
||  mv (Mop2 op popV a2.ms) = Mmove popV dtmp1.mv (Mop2 op dtmp1 a2.ms)

||  mv (Mcompare popV a2.ms) = Mmove popV dtmp1.mv (Mcompare dtmp1 a2.ms)
||  mv (Mcompare a1 popV.ms) = Mmove popV dtmp2.mv (Mcompare a1 dtmp2.ms)
||  mv (m.ms) = m.mv ms
-- Make constants first operand.
and mc (Mcompare (a1 as const _) a2.ms) = Mcompare a2 a1. invj ms
||  mc (m.ms) = m.mc ms
||  mc [] = []
and invj (Mjcond cc l.ms) = Mjcond (mopcc (ccrev (mccop cc))) l. mc ms
||  invj (Mboolcc cc l.ms) = Mboolcc (mopcc (ccrev (mccop cc))) l. mc ms
||  invj (m.ms) = m . invj ms
||  invj [] = []

-- Insert temp regs.
and mr ((m as Mmove a1 _).ms) & (okop a1) = m.mr ms
||  mr ((m as Mmove popV _).ms) = m.mr ms
||  mr ((m as Mmove _ pushV).ms) = m.mr ms
||  mr ((m as Mmove _ Sp).ms) = m.mr ms
||  mr ((m as Mmove _ Vp).ms) = m.mr ms
||  mr ((m as Mmove _ hp).ms) = m.mr ms
||  mr ((m as Mmove _ (reg _)).ms) = m.mr ms
||  mr ((m as Mmove a1 a2).ms) =
	let ms' = mr ms in
	case freeregs ms' (usedregs a2) in
	   [] : m.ms'
	|| r._ : Mmove a1 (reg r).Mmove (reg r) a2.ms'
	end
||  mr (m.ms) = m.mr ms
||  mr [] = []
and freeregs (Mmove a1 (a2 as reg r).ms) ur =
	let ur' = usedregs a1@ur in
	if mem r ur' then
		freeregs ms ur'
	else
		[r]
||  freeregs (Mmove a1 a2.ms) ur = freeregs ms (usedregs a1@usedregs a2@ur)
||  freeregs (Mop2 _ a1 a2.ms) ur = freeregs ms (usedregs a1@usedregs a2@ur)
||  freeregs (Mjumpf _.ms) ur = difference [1;0;2;3;4] ur
||  freeregs (Mjcond _ _.Mcall "GARB".ms) ur = difference [1;0;2;3;4] ur
||  freeregs (Mcall _.ms) ur = difference [3] ur
||  freeregs (Mcalltag _ r.ms) ur = difference [1;3] (r.ur)
||  freeregs (Mjumptag _ r.ms) ur = difference [1;3] (r.ur)
||  freeregs (Mreturn.ms) ur = difference [3] ur
||  freeregs (Mdata.ms) ur = freeregs (totext ms) ur
||  freeregs (Mcom _.ms) ur = freeregs ms ur
||  freeregs _ _ = []
and totext (Mtext.ms) = ms
||  totext (_.ms) = totext ms
||  totext [] = []
and usedregs (reg r) = [r]
||  usedregs (regind r _) = [r]
||  usedregs (regrel r _) = [r]
||  usedregs _ = []
and okop (Sp)	   = true
||  okop (Vp)	   = true
||  okop (hp)	   = true
||  okop (const _) = true
||  okop (idlit _) = true
||  okop (retaddr _) = true
||  okop (reg _)   = true
||  okop _         = false
and mtrans ms = mr (mc (mv (mt (0,0) ms)))
end
