module -- mtrans
--
-- remove all opoV, pushV, popS, pushS, tohp because 360 can't use them
--
#include "../mcode/mcodedef.t.t"
export mtrans;
rec
    srel 0 = Sp
||  srel n = Srel n
and hrel 0 = hp
||  hrel n = hprel n
and vrel 0 = Vp
||  vrel n = Vrel n
and adj (_,_,S) Sp       = srel S
||  adj (_,_,S) (Srel n) = srel (S+n)
||  adj (_,_,S) (Sind n) = Sind (S+n)
||  adj (_,_,S) pushS    = Sind (S-1)
||  adj (_,_,S) popS     = Sind S
||  adj (_,H,_) hp       = hrel H
||  adj (_,H,_) (hprel n)= hrel (H+n)
||  adj (_,H,_) (hpind n)= hpind (H+n)
||  adj (_,H,_) tohp     = hpind H
||  adj (V,_,_) Vp       = vrel V
||  adj (V,_,_) (Vrel n) = vrel (V+n)
||  adj (V,_,_) (Vind n) = Vind (V+n)
||  adj (V,_,_) pushV    = Vind (V-1)
||  adj (V,_,_) popV     = Vind V
||  adj _     a        = a
and chg (V,H,S) pushS    = (V,H,S-1)
||  chg (V,H,S) popS     = (V,H,S+1)
||  chg (V,H,S) tohp     = (V,H+1,S)
||  chg (V,H,S) pushV    = (V-1,H,S)
||  chg (V,H,S) popV     = (V+1,H,S)
||  chg VHS    _         = VHS

and min (V,S) pushS    = (V,S-1)
||  min (V,S) pushV    = (V-1,S)
||  min VS    _         = VS

and nonseq (Mcall _)	= true
||  nonseq Mreturn	= true
||  nonseq (Mcalltag _ _) = true
||  nonseq (Mjumptag _ _) = true
||  nonseq (Mjump _)	= true
||  nonseq (Mjcond _ _) = true
||  nonseq (Mlabel _)	= true
||  nonseq (Mcase _ _ _ _ _ _) = true
||  nonseq (Masm _ _)	= true		-- safe assumption
||  nonseq _		= false

and flush (V,H,S) = (flv V @ flh H @ fls S
			where flh 0 = []
			   || flh n = [Mmove (hprel n) hp]
			and   fls 0 = []
			   || fls n = [Mmove (Srel n) Sp]
			and   flv 0 = []
			   || flv n = [Mmove (Vrel n) Vp])

and mskip VHS (Mtext.ms) = Mtext.mt VHS ms
||  mskip VHS     (m.ms) =     m.mskip VHS ms

and mcntskip VS (Mtext.ms) = cnt VS ms
||  mcntskip VS     (m.ms) = mcntskip VS ms
and
    cnt VS [] = VS
||  cnt (V,S) (Mmove (Srel n) Sp.ms) & (n<0) = cnt (V, S+n) ms
||  cnt VS (Mmove a1 Sp.ms) = VS
||  cnt VS (Mmove a1 a2.ms) = cnt (min (min VS a1) a2) ms
||  cnt VS (Mcompare a1 a2.ms) = cnt (min (min VS a1) a2) ms
||  cnt VS (Mop2 op a1 a2.ms) = cnt (min (min VS a1) a2) ms
||  cnt VS (Mop3 op a1 a2 a3.ms) = cnt (min (min (min VS a1) a2) a3) ms
||  cnt VS (Mboolcc cc a.ms) = cnt (min VS a) ms
||  cnt VS (Mdata.ms) = mcntskip VS ms
||  cnt VS (m.ms) & (nonseq m) = VS
||  cnt VS (m.ms) = cnt VS ms
and
    mt _ [] = []
||  mt (V,H,S) (Mmove (Srel n) Sp.ms) = mt (V, H, S+n) ms
||  mt (V,H,S) (Mmove (hprel n) hp.ms) = mt (V, H+n, S) ms
||  mt VHS (Mmove popV Sp.Mmove (Sind(-1)) a.ms) =
	flush VHS @
	Mmove (Vind 0) Sp.
	Mmove (Vrel 1) Vp.
	Mmove (Srel(-1)) Sp.
	Mmove (Sind 0) a.
	Mmove (Srel 1) Sp.
	mtt ms
||  mt VHS (Mmove a1 a2.ms) =
	let VHS' = chg VHS a1 in
	Mmove (adj VHS a1) (adj VHS' a2) .mt (chg VHS' a2) ms
||  mt VHS (Mcompare a1 a2.ms) =
	let VHS' = chg VHS a1 in
	Mcompare (adj VHS a1) (adj VHS' a2) .mt (chg VHS' a2) ms
||  mt VHS (Mop2 op a1 a2.ms) =
	let VHS' = chg VHS a1 in
	Mop2 op (adj VHS a1) (adj VHS' a2) .mt (chg VHS' a2) ms
||  mt VHS (Mop3 op a1 a2 a3.ms) =
	let VHS'  = chg VHS  a1 in
	let VHS'' = chg VHS' a2 in
	Mop3 op (adj VHS a1) (adj VHS' a2) (adj VHS'' a3) .mt (chg VHS'' a3) ms
||  mt VHS (Mboolcc cc a.ms) = 
	Mboolcc cc (adj VHS a) .mt (chg VHS a) ms
||  mt VHS (Mdata.ms) = Mdata .mskip VHS ms
||  mt VHS (m.ms) & (nonseq m) = flush VHS @ m.mtt ms
||  mt VHS (m.ms) = m.mt VHS ms
and mtt ms = let (V,S) = cnt (0,0) ms in flush (V,0,S) @ mt (-V,0,-S) ms
and mtrans ms = mtt ms
end
