module
#include "../mcode/mcodedef.t.t"
#include "../mcode/mprint.t"
#include "mtrans.t"
--
-- Register allocation
-- Mcode real	comment
-- r0	 r2	tos cache
-- r1-r5 r3-r7
-- r6	 r8	Sp
-- r7	 r9	hp
-- r8	 r10	Vp
-- r9	 r11	base addr
-- r10	 r12	C ret			could be used
-- r11	 r13	frame pointer
-- r12	 r14	ret addr
-- r13	 r15	function addr
-- r14	 r0	scratch
-- r15	 r1	scratch
--
--
export assemblercode, Aregs, Dregs, usecase,
	argcreg, tagreg, bigeqreg, indreg, use3op;
rec
    Aregs = [1;2;3;4;10] @ fail "Out of A-regs"
and Dregs = [1;2;3;4;10] @ fail "Out of D-regs"
and usecase max low high cnt = if cnt=0 then false else false
and use3op = true
and argcreg = reg 2
and tagreg  = reg 2
and bigeqreg= reg 2
and indreg  = reg 3

and spr  = 6
and hpr  = 7
and vpr  = 8
and tmp  = reg 14
and tmp1  = reg 15
-- tags available in the frame
and ctags = ["AP"; "PAIR0"; "PAIR1"; "PAIR2"; "PAIR3"; "TAG"; "TAG0"; "VAP"; "VEK"; "HOLE"; "INT"; "CHAR"; "BOOL"]
-- constants available in the frame
and constants = [16;12;8;4;2;1]
and
    re r c = itos ((r+2)%16) @ c

and otag oeval c = "oeval" @ c
 || otag ounwind c = "ounwind" @ c
 || otag ojfun c = "ojfun" @ c
 || otag omkapl c = "omkapl" @ c
 || otag ogettag c = "ogettag" @ c
 || otag ogc c = "ogc" @ c
 || otag ocmp c = "ocmp" @ c
 || otag oprint c = "oprint" @ c
 || otag onb c = "onb" @ c
 || otag onp c = "onp" @ c
 || otag oargs c = "oargs" @ c
 || otag ovno c = "ovno" @ c
 
and ccof eq c = "eq" @ c
 || ccof ne c = "ne" @ c
 || ccof lt c = "lt" @ c
 || ccof gt c = "gt" @ c
 || ccof le c = "le" @ c
 || ccof ge c = "ge" @ c
 || ccof ltstack c = "lt" @ c
 || ccof ltheap c = "lt" @ c
 || ccof gtstack c = "gt" @ c
 || ccof geheap c = "ge" @ c

and invcc eq = eq
 || invcc ne = ne
 || invcc lt = gt
 || invcc gt = lt
 || invcc le = ge
 || invcc ge = le
 
and aspr ""       ams      = ""
||  aspr ('^'.cs) (am.ams) = amode am (aspr cs ams)
||  aspr (c.cs)   ams      = c.aspr cs ams
 
and oop add c = "al" @ c
 || oop sub c = "sl" @ c
 || oop mul c = "m" @ c
 || oop div c = "d" @ c
 || oop mod c = "d" @ c
 
and 
    amode Vp c = re vpr c
 || amode (Vind i) c = itos (4*i) @ "(" @ re vpr (")"@ c)
 || amode (Vrel _) c = fail "amode Srel"
 || amode pushV c = fail "pushV"
 || amode popV c = fail "popV"
 
 || amode Sp c = re spr c
 || amode (Sind i) c = itos (4*i) @ "(" @ re spr (")"@ c)
 || amode (Srel _) c = fail "amode Srel"
 || amode pushS c = fail "pushS"
 || amode popS c = fail "popS"
 
 || amode hp c = re hpr c
 || amode (hpind i) c = itos (4*i) @ "(" @ re hpr (")"@ c)
 || amode (hprel i) c = fail "amode hprel"
 || amode tohp c = fail "tohp"
 
 || amode (reg i) c = re i c
 || amode (regind r i) c = itos(4*i) @ "(" @ re r (')'.c)
 || amode (regrel _ _) c = fail "amode regrel"

 || amode (glob i) c = i @ c
 || amode (idlit s) c & (mem s ctags) = "Z"@s@"(13)"@ c
 || amode (idlit s) c = "="@s @ c
 || amode (retaddr s) c = '='.s @ c
 || amode (const n) c & (mem n constants) = (if n<0 then "ZM" else "ZP")@itos n@"(13)"@ c
 || amode (const n) c = "="@itos n @ c
 
and amode1 a1 c = amode a1 ('\n'.c)
and amode2 a1 a2 c = amode a1 (','.amode a2 ('\n'.c))

and fixreg Vp = reg vpr
||  fixreg Sp = reg spr
||  fixreg hp = reg hpr
||  fixreg a = a
and move a1 a2 = move' (fixreg a1) (fixreg a2)
and move' (a1 as reg _) (a2 as reg _) c = "\tlr\t" @ amode2 a2 a1 c
||  move' (const 0)     (a2 as reg _) c = "\tslr\t" @ amode2 a2 a2 c
||  move' (a1 as const n)     (a2 as reg _) c & (0 <= n & n <= 4095) =
	"\tla\t" @ amode2 a2 (glob (itos n)) c
||  move' a1            (a2 as reg _) c = "\tl\t" @ amode2 a2 a1 c
||  move' (a1 as reg _)  a2           c = "\tst\t" @ amode2 a1 a2 c
||  move' a1             a2           c = move' a1 tmp (move' tmp a2 c)
 
and comp a1 a2 = comp' (fixreg a1) (fixreg a2)
and comp' (a1 as reg _) (a2 as reg _) c = "\tcr\t" @ amode2 a1 a2 c
||  comp' (a1 as reg _) (const 0)     c = "\tltr\t" @ amode2 a1 a1 c
||  comp' (a1 as reg _)  a2           c = "\tc\t" @ amode2 a1 a2 c
||  comp' a1             a2           c = "\tclc\t" @ amode2 a1 a2 c
 
and aop op a1 a2 = aop' op (fixreg a1) (fixreg a2)
and aop' sub (const 1) (a2 as reg _) c = "\tbctr\t"@ amode a2 (",0\n"@c)
||  aop' op (a1 as reg _) a2 c = "\t"@oop op("r\t" @ amode2 a2 a1 c)
||  aop' op a1            a2 c = "\t"@oop op("\t" @ amode2 a2 a1 c)

and sext a r c = move a r ("\tsrad\t" @ amode r (",32\n"@c))

and isreg (reg _) = true
||  isreg Vp = true
||  isreg Sp = true
||  isreg hp = true
||  isreg _ = false
and c4 n = const (-n*4)
and
    la a1 a2 c & (~isreg a2) = la a1 tmp (move tmp a2 c)
||  la (hpind i) hp c & (i<0) = aop sub (c4 i) hp c
||  la (Sind i) Sp c & (i<0) = aop sub (c4 i) Sp c
||  la (Vind i) Vp c & (i<0) = aop sub (c4 i) Vp c
||  la (regind r i) (reg r1) c & (i<0 & r=r1) = aop sub (c4 i) (reg r) c
||  la (hpind i) a c & (i<0) = move hp a (aop sub (c4 i) a c)
||  la (Sind i) a c & (i<0) = move Sp a (aop sub (c4 i) a c)
||  la (Vind i) a c & (i<0) = move Vp a (aop sub (c4 i) a c)
||  la (regind r i) a c & (i<0) = move (reg r) a (aop sub (c4 i) a c)
||  la a1 a2 c = "\tla\t" @ amode2 a2 a1 c
and call = "\tl\t14,Zcallit(13)\n\tbalr\t14,14\n"
and
    ins (Mmove (hprel i) a.c) = la (hpind i) a (ins c)
 || ins (Mmove (Srel i) a.c) = la (Sind i) a (ins c)
 || ins (Mmove (Vrel i) a.c) = la (Vind i) a (ins c)
 || ins (Mmove (regrel r i) a.c) = la (regind r i) a (ins c)

 || ins (Mmove a pushS .c) = ins (Mmove (Srel(-1)) Sp.Mmove a (Sind 0).c)
 || ins (Mmove a1 a2.c) = move a1 a2 (ins c)
 || ins (Mcalltag t r.c) =
	"\tl\t15,"@otag t ("("@re r (")\n" @ call @ ins c))
 || ins (Mjumptag t r.c) =
	"\tl\t15,"@otag t ("("@re r (")\n\tbr\t15\n" @ ins c))
 || ins (Mjump l.c) = "\tb\t" @ l @ "\n" @ ins c
 || ins (Mjumpf l.c) = "\tl\t15,="@ l @ "\n\tbr\t15\n" @ ins c
 || ins (Mcall l.c) = "\tl\t15,="@ l @ "\n" @ call @ ins c
 || ins (Mreturn.c) = 
	"\tl\t14,0(10)\n\tl\t11,4(10)\n\tla\t10,8(10)\n\tbr\t14\n" @ ins c
 || ins (Mjcond cc l.c) = "\tb"@ ccof cc ('\t'.l @ "\n" @ ins c)
 || ins (Mlabel l.c) = l @ ":\n" @ ins c
 || ins (Mcompare a1 a2.Mjcond cc l.c) & (~isreg a1 & isreg a2)
	= ins (Mcompare a2 a1. Mjcond (invcc cc) l.c)
 || ins (Mcompare a1 a2.c) = comp a1 a2 (ins c)

 || ins (Mboolcc cc a.c) = ins (
	Mmove (const 1) a.
	Mjcond cc "1f".
	Mmove (const 0) a.
	Mlabel "1".
	c)

 || ins (Mop2 op a1 (a2 as reg _).c) =
	aop op a1 a2 (ins c)
 || ins (Mop2 op a1 a2.c) =
	move a2 tmp
	(aop op a1 tmp
	(move tmp a2
	(ins c)))
 || ins (Mop3 op a1 a2 (a3 as reg _).c) & (a2=a3 & (op=add | op=sub)) =
	aop op a1 a3 (ins c)
 || ins (Mop3 add a1 a2 (a3 as reg _).c) & (a1=a3) =
	aop add a2 a3 (ins c)
 || ins (Mop3 mul a1 a2 a3.c) =
	move a2 tmp
	(aop mul a1 tmp
	(move tmp1 a3
	(ins c)))
 || ins (Mop3 div a1 a2 a3.c) =
	sext a2 tmp
	(aop div a1 tmp
	(move tmp a3
	(ins c)))
 || ins (Mop3 mod a1 a2 a3.c) =
	sext a2 tmp
	(aop mod a1 tmp
	(move tmp1 a3
	(ins c)))
 || ins (Mop3 op a1 a2 a3.c) =
	move a2 tmp
	(aop op a1 tmp 
	(move tmp a3
	(ins c)))

 || ins (Mdata.c) = "\t.data\n" @ ins c
 || ins (Mtext.c) = "\t.text\n" @ ins c
 || ins (Mword (glob a).c) = "\t.long\t" @ a @ "\n" @ ins c
 || ins (Mword (const i).c) = "\t.long\t" @ itos i @ "\n" @ ins c
 || ins (Mword (idlit s).c) = "\t.long\t" @ s @ "\n" @ ins c
 || ins (Mstring s.c) = itlist (\x.\p.
 				  "\t.byte\t" @ itos(ord x)@"\n"@p) s 
				 ("\t.align\t2\n"@ins c)
 || ins (Mexport a.c) = "\t.globl\t" @ a @ "\n" @ ins c
 || ins (Mcom s.c) = "/ " @ s @ "\n" @ ins c
 || ins (Masm s l.c) = aspr s l @ "\n" @ ins c
 || ins (Malign.c) = "\t.align\t2\n" @ ins c
 || ins (Mfunbegin s.c) ="\tbalr\t11,0\nB"@s@":\n\tusing\tB"@s@",11\n" @ ins c
 || ins (Mfunend .c) = "\t.ltorg\n" @ ins c
 || ins [] = []
 || ins (m._) = fail ("ins: strange Mcode " @ mprint [m])

and prel = "oeval=0\nounwind=4\nojfun=8\nomkapl=12\nogettag=16\n"
and prez = "Z=0\nZP=100\nZN=200\nZAP=Z+0\nZPAIR0=Z+4\nZPAIR1=Z+8\nZPAIR2=Z+12\nZPAIR3=Z+16\nZTAG=Z+20\nZTAG0=Z+24\nZVAP=Z+28\nZVEK=Z+32\nZHOLE=Z+36\nZINT=Z+40\nZCHAR=Z+44\nZBOOL=Z+48\nZcallit=60\ZGARB=64\nZP1=ZP+0\nZP2=ZP+4\nZP4=ZP+8\nZP8=ZP+12\nZP12=ZP+16\nZP16=ZP+20\nZN1=ZN+0\nZN2=ZN+4\nZN4=ZN+8\nZN8=ZN+12\nZN12=ZN+16\nZN16=ZN+20\n"
and assemblercode s = prel@prez@ ins (mtrans s)

end
