extern char *tgoto();
char PC;	/* padding character */
char *BC;
char *UP;
short ospeed;
static char *cl;	/* clear display */
static char *cm;	/* cursor movement */

static int bs;
static int pt;
static int li, co;	/* lines, columns */
static char *rawp;
static char rawbuffer[50];

static int init = 0;

extern int *STRING[], *INT[];
extern int **mknode();
#define NIL ((int **)0)

static int **
mkint(s)
int s;
{
    return mknode(INT, (int **)s, NIL);
}

static int **
mkstr(s)
char *s;
{
    return mknode(STRING, (int **)s, NIL);
}

static
putraw(c)
{
    *rawp++ = c;
}

int **
MoveTo(col, row)
{
    GetTermCaps();
    rawp = rawbuffer;
    if (cm && *cm) {
	tputs(tgoto(cm, col, row), 1, putraw);
    }
    *rawp = 0;
    return mkstr(rawbuffer);
}

int **
Columns()
{
    GetTermCaps();
    return mkint(co);
}

int **
Lines()
{
    GetTermCaps();
    return mkint(li);
}

int **
ClearScreen()			/* clear the whole screen and home */
{
    GetTermCaps();
    rawp = rawbuffer;
    if (cl && *cl) {
	tputs(cl, li, putraw);	/* send the clear screen code */
    }
    *rawp = 0;
    return mkstr(rawbuffer);
}

static char *
Mytgetstr(id, area)
register char *id, **area;
{
    register char *cp;
    char *tgetstr();

    if ((cp = tgetstr(id, area)) == (char *)0)
	return ("");
    return (cp);
}

static
GetTermCaps()			/* read in the needed terminal capabilites */
{
    register int i;
    static char buffer[1024];	/* for string values */
    static char bp[1024];
    char *area = buffer;
    char *MyTerm;
    char *getenv();


    if (init)
	return;
    init = 1;
    MyTerm = getenv("TERM");
    if (!MyTerm[0])
      MyTerm = "dumb";

    i = tgetent(bp, MyTerm);
    if (i <= 0) {
	if (i == -1) {
	    printf ("Cannot open /etc/termcap.\n");
	    finish(1);
	} else if (i == 0) {
	    printf ("No entry for terminal type \"%s\"\n", getenv("TERM"));
	    finish(1);
	}
    }

    co = 0; co = tgetnum("co");
    li = 0; li = tgetnum("li");	

    UP = Mytgetstr("up", &area);
    BC = Mytgetstr("bc", &area);
    cl = Mytgetstr("cl", &area);
    cm = Mytgetstr("cm", &area);

    if (co < 2) co = 80;	/* just in case */
    if (li < 1) li = 24;
}
