/*
**	dialog:		Haskell I/O.
**
*/
#define String (List Char)
#define Name String
module
export Request, Response, IOError, stdin, stdout, stderr, stdecho;
rec type Request =
    ReadFile 	    Name +
    WriteFile	    Name String +
    AppendFile	    Name String +
    ReadBinFile	    Name +
    WriteBinFile    Name Bin +
    AppendBinFile   Name Bin +
    DeleteFile	    Name +
    StatusFile      Name +
    ReadChan        Name +
    AppendChan      Name String +
    ReadBinChan     Name +
    AppendBinChan   Name Bin +
    StatusChan      Name +
    Echo	    Bool +
    GetArgs         +
    GetEnv	    Name +
    SetEnv          Name String +
    ReadChannels    (List Name) +
    ReadBinChannels (List Name) +
    CreateProcess   (List Response -> List Request) +
    CreateDirectory Name String +
    /* junk! */
    OpenFile	    Name Bool +
    OpenBinFile     Name Bool +
    CloseFile       File +
    ReadVal         File +
    ReadBinVal      File +
    WriteVal        File Char +
    WriteBinVal     File Bin +
    /* extra */
    Sleep	    Int +
    ChangeDirectory Name
and type Response =
    Success         +
    Str             String +
    Bn Bin          +
    Failure         IOError +
    Tag             (List (Name#Char)) +
    BinTag          (List (Name#Bin)) +
    Fil             File
and type IOError =
    WriteError	    String +
    ReadError       String +
    SearchError     String +
    FormatError     String +
    OtherError      String
and stdin =         "stdin"
and stdout =        "stdout"
and stderr =        "stderr"
and stdecho =       "stdecho"
end

