/*
**	Array_fail:
*/
module
export	fail_funny_bounds,
	fail_index_too_small,
	fail_index_too_big;

rec
	fail_funny_bounds lo hi =
		fail ("assocarray: funny bounds: lo=" @ itos lo @ 
		      ", hi=" @ itos hi @ "\n")
and

	fail_index_too_small siz a i = 
		fail( 	"arrayindexing: index = " @ itos i @ 
		  	" too small (" @ itos a @ "..." @ itos (a+siz-1) @ ")\n"
			)
and
	fail_index_too_big siz a i = 
		fail( 	"arrayindexing: index = " @ itos i @ 
		  	" too big (" @ itos a @ "..." @ itos (a+siz-1) @ ")\n"
			)

end
