#include "../runtime/machdep.M"
	.data
	.malign
	.export	CParray
CParray:
	.word	FUN
	.word	VCParray
	.export	VCParray
VCParray:
	.word	$4
	.word	CParray
	.word	unw4
	.word	J4CParray
	.word	vunw4
	.word	$0
	.word	$0
	.word	$1
	.word	C_elemfilter
	.text
	.export	S4CParray
S4CParray:
	move	$5(Sp),Vpush
	.export	J4CParray
J4CParray:
	.funbegin	CParray

#define	lo 0(Sp)
#define hi 1(Sp)
#define	reducefun 2(Sp)
#define list 3(Sp)

#define Blo 0(Vp)
#define Bhi 1(Vp)
#define Bindex 2(Vp)
#define Bsize 3(Vp)
#define Pva 4(Vp)
#define Pv 5(Vp)
#define Pvek 6(Vp)
#define Pauxvek 7(Vp)

#define BASICVARSIZE 8

/* offsets into the aux vector for lo (the lower bound) and the list */
#define offset_list 2
#define offset_lo 3

	; allocate local vars
	move	$-BASICVARSIZE(Vp),Vp

	; EVAL lo
	move	lo,r0
	move	0(r0),r1
	call	oeval(r1)
	move	1(r0),Blo

	; EVAL hi
	move	hi,r0
	move	0(r0),r1
	call	oeval(r1)
	move	1(r0),Bhi

	; compute Bsize
	move	Bhi,Bsize
	sub2	Blo,Bsize
	add2	$1,Bsize

	comp	Bsize,$1
	jge	Ll0
;	move	lo,0(Sp)
;	move	hi,1(Sp)
	move	lo,reducefun
	move	hi,list
	move	$2(Sp),Sp
	move	$BASICVARSIZE(Vp),Vp
	jumpf	J2CPfail_funny_bounds

Ll0:
	; MEMCHECK 11*size
	move	Bsize,ARGCREG
	mul2	$11,ARGCREG
	call	NGARB
	
	; allocate the array
	move	Hp,Pvek
	move	$VEK,toH
	move	Bsize,toH
	move	Hp,Pv		; init pointer into the vector
	move	Bsize,DTMP
	ADDAW(DTMP,Hp)
	
	; allocate the auxilliary array
	move	Hp,Pauxvek
	move	$VEK,toH
	move	Bsize,toH
	add2	$2,-1(Hp)
	move	list,toH
	move	lo,toH
	move	Hp,Pva		; init pointer into the aux vector
	move	Bsize,DTMP
	ADDAW(DTMP,Hp)

	; initialize the loop
	move	Blo,Bindex
Lloopstart:
	comp 	Bindex,Bhi
	jgt	Lloopend

		; constr INT-node: Bindex
		move	$INT,toH
		move	Bindex,toH
		; fill in aux-array location to point at
		; beginning of VAP node (below)
		move	Pva,ATMP
		move	Hp,0(ATMP)
		; constr VAP-node: elemfilter index auxvek
		move	$VAP,toH
		move	$VC_elemfilter,toH
		move	$-4(Hp),toH
		move	Pauxvek,toH
		; fill in array-location to point at
		; beginning of AP node (below)
		move	Pv,ATMP
		move	Hp,0(ATMP)
		; constr AP-node: reducefun vap-node
		move	$AP,toH
		move	reducefun,toH
		move	$-6(Hp),toH

		add2	$1,Bindex	; increment index
		move	Pv,ATMP		; increment pointer into vector
		move	$1(ATMP),Pv
		move	Pva,ATMP	; increment pointer into aux vector
		move	$1(ATMP),Pva

		jump	Lloopstart

Lloopend:
	move	Blo,DTMP
	move	Pvek,ATMP
	move	$BASICVARSIZE(Vp),Vp
	move	Vpop,Sp
	move	-1(Sp),r0
	move	DTMP,1(r0)
	move	ATMP,2(r0)
	move	$TAG,0(r0)
	.export	assocarrayreturn
assocarrayreturn:
	return
	.funend


	.data
	.malign
C_elemfilter:
	.word	FUN
	.word	VC_elemfilter
VC_elemfilter:
	.word	$2
	.word	C_elemfilter
	.word	unw2
	.word	J2C_elemfilter
	.word	vunw2
	.word	$0
	.word	$0
	.word	$0
	.text
S2C_elemfilter:
	move	$3(Sp),Vpush
J2C_elemfilter:
	.funbegin	C_elemfilter


	move	1(Sp),r0		; access the array
	move	offset_list(r0),Spush	; push the list
	move	r0,Spush		; location for tail
	move	r0,Spush		; location for v
	move	r0,Spush		; location for i
	move	r0,Spush		; location for TOUPDATE
#undef list
#define array 6(Sp)
#define index 5(Sp)
#define list 4(Sp)
#define tail 3(Sp)
#define v 2(Sp)
#define i 1(Sp)
#define TOUPDATE 0(Sp)

elemfilter2:
	; eval list
	move	list,r0
	move	0(r0),r1
	call	oeval(r1)

	comp	0(r0),$TAG0	; nil ?
	jeq	LTnil

	move	2(r0),tail
	move	1(r0),r0

	; eval the pair
	move	0(r0),r1
	call	oeval(r1)

	move	1(r0),i
	move	2(r0),v

	; eval i
	move	i,r0
	move	0(r0),r1
	call	oeval(r1)

	; MEMCHECK
	comp	Hp,_ehp
	jlth	LT9
	move	r0,Spush
	call	GARB
	move	Spop,r0
LT9:

#define OFFSETREG DTMP
#define ARRAYREG ATMP
	move	1(r0),OFFSETREG

	move	array,ARRAYREG
	move	offset_lo(ARRAYREG),r1
	sub2	1(r1),OFFSETREG		; OFFSETREG := i - lo
	comp	OFFSETREG,$0		; if offset < 0 (ie i < lo) ...
	jlt	LTnext			; .. ignore this element
	add2	$2,OFFSETREG		; compensate for list and lo
	comp	OFFSETREG,1(ARRAYREG)	; if offset >= vector size (ie, i > hi), ...
	jge	LTnext			; .. ignore this element


	ADDAW(OFFSETREG,ARRAYREG)	; 2(ATMP) holds the pointer to update
	move	2(ARRAYREG),TOUPDATE

	move	Hp,2(ARRAYREG)		; aux-vek entry point to new filter node

	move	$VAP,toH
	move	$VC_elemfilter,toH
	move	i,toH			; ... of this index
	move	array,toH		; the array
	move	TOUPDATE,r0
	move	$PAIR1,0(r0)
	move	v,1(r0)
	move	$-4(Hp),2(r0)

	; now was the index which we just updated
	; the one we asked for?
	.export	filternext1
filternext1:
	move	index,r1
	move	i,ATMP
	comp	1(r1),1(ATMP)
	jeq	LT10
	; no:
LTnext:
	move	tail,list
	jump	elemfilter2
LT10:
	; yes: orderly return:
	; first replace the list in the array by the tail.
	move	array,ATMP
	move	tail,offset_list(ATMP)
	move	Vpop,Sp
	; now TOUPDATE must be in r0!
	return

LTnil:
	; the list is in r0
	move	array,ATMP
	move	r0,offset_list(ATMP)
	move	Vpop,Sp
	move	-1(Sp),r0
	move	$0,1(r0)
	move	$TAG0,0(r0)
	return


;
;	T H E   I N D E X   O P E R A T O R 
;
	.data
	.malign
	.export	CPaindex
CPaindex:
	.word	FUN
	.word	VCPaindex
	.export	VCPaindex
VCPaindex:
	.word	$2
	.word	CPaindex
	.word	unw2
	.word	J2CPaindex
	.word	vunw2
	.word	$0
	.word	$0
	.word	$2
	.word	CPfail_index_too_small
	.word	CPfail_index_too_big
	.text
	.export	S2CPaindex
S2CPaindex:
	move	$3(Sp),Vpush
	.export	J2CPaindex
J2CPaindex:
	.funbegin	CPaindex
#undef i
#define a 0(Sp)
#define i 1(Sp)
	move	a,r0
	move	0(r0),r1
	call	oeval(r1)

	move	i,r0
	move	0(r0),r1
	call	oeval(r1)
	.export index1
index1:
	move	a,ATMP
	move	1(r0),DTMP
	sub2	1(ATMP),DTMP
	comp	DTMP,$0
	jge	LT30

	; index out of bounds (too small).
	move	2(ATMP),Spush
	jumpf	J3CPfail_index_too_small
LT30:
	move	2(ATMP),ATMP
	comp	DTMP,1(ATMP)
	jlt	LT31
	; index out of bounds (too big)
	move	ATMP,Spush
	jumpf	J3CPfail_index_too_big

LT31:
	ADDAW(DTMP,ATMP)
	move	2(ATMP),r0
	move	$2(Sp),Sp
	jumpf	evalupdunw
	.funend

; lower bound
	.data
	.malign
	.export	CPlowerbound
CPlowerbound:
	.word	FUN
	.word	VCPlowerbound
	.export	VCPlowerbound
VCPlowerbound:
	.word	$1
	.word	CPlowerbound
	.word	unw1
	.word	J1CPlowerbound
	.word	vunw1
	.word	$0
	.word	$0
	.word	$0
	.text
	.export	S1CPlowerbound
S1CPlowerbound:
	move	$2(Sp),Vpush
	.export	J1CPlowerbound
J1CPlowerbound:
	.funbegin	CPlowerbound

	move	a,r0
	move	0(r0),r1
	call	oeval(r1)

	move	a,ATMP
	move	1(ATMP),DTMP

	move	Vpop,Sp
	move	-1(Sp),r0
	move	DTMP,1(r0)
	move	$INT,0(r0)
	return
	.funend

; upper bound
	.data
	.malign
	.export	CPupperbound
CPupperbound:
	.word	FUN
	.word	VCPupperbound
	.export	VCPupperbound
VCPupperbound:
	.word	$1
	.word	CPupperbound
	.word	unw1
	.word	J1CPupperbound
	.word	vunw1
	.word	$0
	.word	$0
	.word	$0
	.text
	.export	S1CPupperbound
S1CPupperbound:
	move	$2(Sp),Vpush
	.export	J1CPupperbound
J1CPupperbound:
	.funbegin	CPupperbound

	move	a,r0
	move	0(r0),r1
	call	oeval(r1)

	move	a,ATMP
	move	1(ATMP),DTMP
	move	2(ATMP),ATMP
	add2	1(ATMP),DTMP
	sub2	$1,DTMP

	move	Vpop,Sp
	move	-1(Sp),r0
	move	DTMP,1(r0)
	move	$INT,0(r0)
	return
	.funend

