#include <stdio.h>
#include <a.out.h>
#include <sys/types.h>
#include <sys/stat.h>

#if defined(sun) && defined(sparc)
/* Sparc (Sun 4) macros */
#undef relocation_info
#define relocation_info	                reloc_info_sparc
#define RELOC_ADDRESS(r)		((r)->r_address)                 
#define RELOC_EXTERN_P(r)               ((r)->r_extern)      
#define RELOC_TYPE(r)                   ((r)->r_index)  
#define RELOC_SYMBOL(r)                 ((r)->r_index)   
#define RELOC_MEMORY_SUB_P(r)		0
#define RELOC_MEMORY_ADD_P(r)           0
#define RELOC_ADD_EXTRA(r)              ((r)->r_addend)       
#define RELOC_PCREL_P(r)             \
        ((r)->r_type >= RELOC_DISP8 && (r)->r_type <= RELOC_WDISP22)
#define RELOC_VALUE_RIGHTSHIFT(r)       (reloc_target_rightshift[(r)->r_type])
#define RELOC_TARGET_SIZE(r)            (reloc_target_size[(r)->r_type])
#define RELOC_TARGET_BITPOS(r)          0
#define RELOC_TARGET_BITSIZE(r)         (reloc_target_bitsize[(r)->r_type])

/* Note that these are very dependent on the order of the enums in
   enum reloc_type (in a.out.h); if they change the following must be
   changed */
/* Also note that the last few may be incorrect; I have no information */
static int reloc_target_rightshift[] = {
  0, 0, 0, 0, 0, 0, 2, 2, 10, 0, 0, 0, 0, 0, 0,
};
static int reloc_target_size[] = {
  0, 1, 2, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
};
static int reloc_target_bitsize[] = {
  8, 16, 32, 8, 16, 32, 30, 22, 22, 22, 13, 10, 32, 32, 16,
};

#define	MAX_ALIGNMENT	(sizeof (double))
#endif

#ifdef sequent
#define RELOC_ADDRESS(r)		((r)->r_address)
#define RELOC_EXTERN_P(r)		((r)->r_extern)
#define RELOC_TYPE(r)		((r)->r_symbolnum)
#define RELOC_SYMBOL(r)		((r)->r_symbolnum)
#define RELOC_MEMORY_SUB_P(r)	((r)->r_bsr)
#define RELOC_MEMORY_ADD_P(r)	1
#undef RELOC_ADD_EXTRA
#define RELOC_PCREL_P(r)		((r)->r_pcrel || (r)->r_bsr)
#define RELOC_VALUE_RIGHTSHIFT(r)	0
#define RELOC_TARGET_SIZE(r)		((r)->r_length)
#define RELOC_TARGET_BITPOS(r)	0
#define RELOC_TARGET_BITSIZE(r)	32
#endif

/* Default macros */
#ifndef RELOC_ADDRESS
#define RELOC_ADDRESS(r)		((r)->r_address)
#define RELOC_EXTERN_P(r)		((r)->r_extern)
#define RELOC_TYPE(r)		((r)->r_symbolnum)
#define RELOC_SYMBOL(r)		((r)->r_symbolnum)
#define RELOC_MEMORY_SUB_P(r)	0
#define RELOC_MEMORY_ADD_P(r)	1
#undef RELOC_ADD_EXTRA
#define RELOC_PCREL_P(r)		((r)->r_pcrel)
#define RELOC_VALUE_RIGHTSHIFT(r)	0
#define RELOC_TARGET_SIZE(r)		((r)->r_length)
#define RELOC_TARGET_BITPOS(r)	0
#define RELOC_TARGET_BITSIZE(r)	32
#endif

#ifndef MAX_ALIGNMENT
#define	MAX_ALIGNMENT	(sizeof (int))
#endif

#ifdef sun
#define N_TROFF N_TRELOFF
#define N_DROFF N_DRELOFF
#endif

#ifdef vax
#define N_DATAOFF(x)    (N_TXTOFF(x) + (x).a_text)
#define N_TROFF(x)      (N_DATAOFF(x) + (x).a_data)
#define N_DROFF(x)      (N_TROFF(x) + (x).a_trsize)
#endif

static int debug = 0;
char *malloc();
char *load_errmsg = 0;
static void addglob(), dprintf(), error();

typedef unsigned long coreaddr;

struct gtab {
    struct gtab *next;
    coreaddr value;
    struct relocation_info reloc;
    coreaddr pcr;
    int claimed;
    char name[1];
};

#define NHASH 255
static struct gtab *globtabs[NHASH], *undeftabs[NHASH];

extern struct {
    char *n;
    coreaddr l;
} predefs[];

static void
setval(p, v, rp, pcr)
coreaddr p, v, pcr;
struct relocation_info *rp;
{
    coreaddr mask;

#ifdef DEBUG
    dprintf("rel v=%x ", v);
#endif

    if (RELOC_PCREL_P(rp))
	v -= pcr;
#ifdef RELOC_ADD_EXTRA
    v += RELOC_ADD_EXTRA(rp);
#endif
    v >>= RELOC_VALUE_RIGHTSHIFT(rp);

    /* Unshifted mask for relocation */
    mask = 1 << RELOC_TARGET_BITSIZE(rp) - 1;
    mask |= mask - 1;
    v &= mask;

    /* Shift everything up to where it's going to be used */
    v <<= RELOC_TARGET_BITPOS(rp);
    mask <<= RELOC_TARGET_BITPOS(rp);

#ifdef DEBUG
    dprintf("v'=%x m=%x %x:%x->", v, mask, p, *(long *)p);
#endif

    switch (RELOC_TARGET_SIZE(rp)) {
    case 0:
	if (RELOC_MEMORY_SUB_P(rp))
	    v -= mask & *(char *) p;
	else if (RELOC_MEMORY_ADD_P(rp))
	    v += mask & *(char *) p;
	*(char *) p &= ~mask;
	*(char *) p |= v;
	break;

    case 1:
	if (RELOC_MEMORY_SUB_P(rp))
	    v -= mask & *(short *) p;
	else if (RELOC_MEMORY_ADD_P(rp))
	    v += mask & *(short *) p;
	*(short *) p &= ~mask;
	*(short *) p |= v;
	break;
	
    case 2:
	if (RELOC_MEMORY_SUB_P(rp))
	    v -= mask & *(long *) p;
	else if (RELOC_MEMORY_ADD_P(rp))
	    v += mask & *(long *) p;
	*(long *) p &= ~mask;
	*(long *) p |= v;
	break;

    default:
	error("Unimplemented relocation", "");
    }
#ifdef DEBUG
    dprintf("%x\n", *(long *)p);
#endif
}

static int
hash(s)
register char *s;
{
    register int r;
    for(r = 0; *s; s++)
	r = r + r + r + *s;
    if (r < 0)
	r = -r;
    return r%NHASH;
}

static void
inittab()
{
    int i;

    for(i = 0; predefs[i].n; i++)
	addglob(predefs[i].n, predefs[i].l);
}

static
struct gtab *
entry(name, value, next)
char *name;
coreaddr value;
struct gtab *next;
{
    struct gtab *p;

    p = (struct gtab*)malloc(sizeof (struct gtab) + strlen(name));
    p->next = next;
    p->value = value;
    p->claimed = 0;
    strcpy(p->name, name);
    return p;
}

static coreaddr
lookup(name)
char *name;
{
    struct gtab *p;

#ifdef DEBUG
    dprintf("looking for %s...", name);
#endif /*DEBUG*/
    for (p = globtabs[hash(name)]; p; p = p->next) {
	if (strcmp(p->name, name) == 0) {
#ifdef DEBUG
	    dprintf("found %x\n", p->value);
#endif /*DEBUG*/
	    return p->value;
	}
    }
#ifdef DEBUG
    dprintf("not found\n");
#endif /*DEBUG*/
    return 0;
}

void
scantab(f)
int (*f)();
{
    struct gtab *p;
    int i;

    for(i = 0; i < NHASH; i++) {
	for(p = globtabs[i]; p; p = p->next) {
	    if (!p->claimed) {
		(*f)(p->name, p->value);
		p->claimed = 1;
	    }
	}
    }
}

static void
addundef(name, value, rp, pcr)
char *name;
coreaddr value, pcr;
struct relocation_info *rp;
{
    struct gtab **t = &undeftabs[hash(name)];
#ifdef DEBUG
    dprintf("addundef %s %x\n", name, value);
#endif /*DEBUG*/
    *t = entry(name, value, *t);
    (*t)->reloc = *rp;
    (*t)->pcr = pcr;
}

static void
addglob(name, value)
char *name;
coreaddr value;
{
    struct gtab **p;
    struct gtab **t = &globtabs[hash(name)];

#ifdef DEBUG
    dprintf("addglob %s %x\n", name, value);
#endif /*DEBUG*/

    for(p = &undeftabs[hash(name)]; *p; ) {
	if (strcmp(name, (*p)->name) == 0) {
#ifdef DEBUG
	    dprintf("resolve %s %x to %x\n", (*p)->name, (*p)->value, value);
#endif /*DEBUG*/
	    setval((*p)->value, value, &(*p)->reloc, (*p)->pcr);
	    *p = (*p)->next;
	} else
	    p = &(*p)->next;
    }
    *t = entry(name, value, *t);
}

static
printundef()
{
    struct gtab *p;
    int i;

    for(i = 0; i < NHASH; i++)
	for(p = undeftabs[i]; p; p = p->next)
	    printf("Undef %s\n", p->name);
}

#ifdef DEBUG
static void
dprintf(a1, a2, a3, a4, a5, a6, a7, a8)
{
    if (debug)
	printf(a1, a2, a3, a4, a5, a6, a7, a8);
}
#endif

static void
relocate(fi, raddr, size, symtab, taddr, daddr)
FILE *fi;
coreaddr raddr;
int size;
struct nlist *symtab;
coreaddr taddr, daddr;
{
    int i;
    struct relocation_info rel;
    coreaddr d, adr;
    coreaddr p;
    char *name;
    int type;

    for(i = 0; i < size; i+=sizeof(struct relocation_info)) {
	fread(&rel, sizeof(struct relocation_info), 1, fi);
	adr = RELOC_ADDRESS(&rel);
	p = (coreaddr)(raddr + adr);
	if (RELOC_EXTERN_P(&rel)) {
	    name = symtab[RELOC_SYMBOL(&rel)].n_un.n_name;
#ifdef DEBUG
	    dprintf("reloc %4x, sym=%-14s (%3d), pc=%d, len=%d, bsr=%d\n",
		   adr, name, RELOC_SYMBOL(&rel),
		   RELOC_PCREL_P(&rel), RELOC_TARGET_SIZE(&rel), RELOC_MEMORY_SUB_P(&rel));
#endif /*DEBUG*/
	    d = lookup(name);
	    if (!d)
		addundef(name, (coreaddr)p, &rel, taddr);
	} else {
	    type = RELOC_TYPE(&rel);
#ifdef DEBUG
	    dprintf("reloc %4x, %02x, len=%d\n", adr, type, RELOC_TARGET_SIZE(&rel));
#endif /*DEBUG*/
	    switch(type) {
	    case N_TEXT:
	    case N_TEXT|N_EXT:
	    case N_DATA:
	    case N_DATA|N_EXT:
	    case N_BSS:
	    case N_BSS|N_EXT:
		break;
	    default:
		error("bad reloc type", "");
		return;
	    }
	    d = (coreaddr)(type &N_TEXT ? taddr : daddr);
	}
	if (d)
	    setval(p, d, &rel, taddr);
    }
}

static void
readobj(name)
char *name;
{
    FILE *fi;
    off_t o;
    register j, nsyms;
    struct stat stb;
    struct exec mag_exp;
    char *strp;
    int strsiz;
    int size;
    int csize;
    char *taddr, *daddr, *baddr;
    struct nlist *symtab;
    
    fi = fopen(name, "r");
    if (fi == NULL) {
	error(name, "cannot open");
	return;
    }
    fread((char *)&mag_exp, 1, sizeof(mag_exp), fi);
    if (N_BADMAG(mag_exp)) {
	error(name, "bad format");
	fclose(fi);
	return;
    }
    o = N_SYMOFF(mag_exp) - sizeof (struct exec);
    fseek(fi, o, 1);
#if 0
    nsyms = mag_exp.a_syms / sizeof(struct nlist);
#else
    /* avoid __udivsi3 */
    nsyms = divi(mag_exp.a_syms, sizeof(struct nlist));
#endif
    if (nsyms == 0) {
	error(name, "no name list");
	fclose(fi);
	return;
    }
    stat(name, &stb);
    if (N_STROFF(mag_exp) + sizeof (off_t) > stb.st_size) {
	error(name, "old format .o (no string table) or truncated file");
	fclose(fi);
	return;
    }
    o = ftell(fi);
    fseek(fi, sizeof(struct nlist) * nsyms, 1);
    if (fread((char *)&strsiz, sizeof(strsiz), 1, fi) != 1) {
	error(name, "no string table (old format .o?)");
	fclose(fi);
	return;
    }
    strp = (char *)malloc(strsiz);
    if (strp == NULL) {
	error(name, "ran out of memory");
	fclose(fi);
	return;
    }
    if (fread(strp+sizeof(strsiz), strsiz-sizeof(strsiz), 1, fi) != 1) {
	error(name, "error reading string table");
	fclose(fi);
	return;
    }
    symtab = (struct nlist *)malloc(mag_exp.a_syms);
    fseek(fi, N_SYMOFF(mag_exp), 0);
    fread((char *)symtab, sizeof(struct nlist), nsyms, fi);
    size = mag_exp.a_text + mag_exp.a_data + mag_exp.a_bss;
    for (j = 0; j < nsyms; j++) {
	symtab[j].n_un.n_name = symtab[j].n_un.n_strx + strp;
	if (symtab[j].n_type == N_EXT && symtab[j].n_value != 0) {
	    csize = symtab[j].n_value;
#ifdef DEBUG
	    dprintf("Convert comm to bss for %s, size %d\n", symtab[j].n_un.n_name, csize);
#endif
	    symtab[j].n_value = size;
	    symtab[j].n_type = N_BSS | N_EXT;
	    size += csize;
	}
    }
#ifdef DEBUG
    dprintf("magic = %8o\n", mag_exp.a_magic);
    dprintf("text  = %8d\n", mag_exp.a_text);
    dprintf("data  = %8d\n", mag_exp.a_data);
    dprintf("bss   = %8d\n", mag_exp.a_bss);
    dprintf("syms  = %8d\n", mag_exp.a_syms);
    dprintf("comm  = %8d\n", csize);
#endif /*DEBUG*/
    taddr = malloc(size);
    daddr = taddr + mag_exp.a_text;
    baddr = daddr + mag_exp.a_data;
#ifdef DEBUG
    dprintf("text=%x, data=%x, bss=%x\n", taddr, daddr, baddr);
#endif /*DEBUG*/
    for(j = 0; j < nsyms; j++) {
#ifdef DEBUG
	dprintf("%3d %-14s %02x %8x\n", j, symtab[j].n_un.n_name,
	       symtab[j].n_type, symtab[j].n_value);
#endif /*DEBUG*/
	if ((symtab[j].n_type & N_EXT) && (symtab[j].n_type & N_TYPE)) {
	    addglob(symtab[j].n_un.n_name, 
		    symtab[j].n_value + (coreaddr)(symtab[j].n_type & N_TEXT ? taddr :
					       symtab[j].n_type & N_DATA ? daddr :
					       baddr));
	}
    }
    fseek(fi, N_TXTOFF(mag_exp), 0);
    fread(taddr, 1, mag_exp.a_text + mag_exp.a_data, fi);
    fseek(fi, N_TROFF(mag_exp), 0);

    relocate(fi, taddr, mag_exp.a_trsize, symtab, taddr, daddr);
    relocate(fi, daddr, mag_exp.a_drsize, symtab, taddr, daddr);

    free(symtab);
    free(strp);
    fclose(fi);
}

static void
error(n, s)
char *n, *s;
{
    static char ebuf[1000];
    sprintf(ebuf, "load: %s %s", n, s);
    load_errmsg = ebuf;
}

void
loadmodule(s)
char *s;
{
    static int init = 0;
    int i;

    load_errmsg = 0;
    if (!init) {
	inittab();
	init = 1;
    }
    readobj(s);
    for(i = 0; i < NHASH; i++)
	if (undeftabs[i]) {
	    error(undeftabs[i]->name, "undefined");
	    return;
	}
}
