#include <OK>
#include "../misc/misc.t"
#include "../misc/flags.t"
#include "../expr/read.t"
#include "../expr/id.t"
#include "../expr/id.t.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/types.t.t"
#include "../expr/impexp.t.t"
#include "../transform/cutil.t"
#include "imisc.t"
#include "Cexpr.t"
#include "idsubst.t"
#include "compile.t"
#include "toplev.t"
#include "iload.t"
#include "mkprt.t"
#include "topprt.t"
#include "intr.t"
#include "../version.t"
#include "../transform/hexpr.t"
let prenv (mkimpid i t _) = oprid i @ ":" @ iprttype t @ "\n"
||  prenv (i as mkimpeqtype _ _ _) = iprimpeqtype i
in
let extl lib bs =
	let rec lib' = new @ lib
	and new = map (\(i,e).(i,(Comb (prid i) o compile o idsubst lib') e)) bs
 	in lib'
and exte bs = bs
in
let rec process lib env s =
	case topparse s in
	   (Com_end, _) : "Bye\n"
	|| (Com_empty, l) : process' lib env l
	|| (Com_load s is, ll) :
		case cload s is in
		   Yes bs : concmap prenv is @ process' (mkprt is @ bs @ lib) 
						        (is @ env) ll
		|| No msg : msg @ "\n" @ process' lib env ll
		end
	|| (Com_mload e, ll) :
		case cmodule env e in
		   Yes (ts,bs) : 
			concmap prenv ts @ process' (mkprt ts @ extl lib bs) 
						    (ts @ env) ll
		|| No msg : msg @ "\n" @ process' lib env ll
		end
	|| (Com_eval e, ll) :
		case cexpr lib env e in
		   Yes E :
			let e' = idsubst lib E in
			let v = compile e' in (if TopShow then show_Cexpr e' @ "\n" else "") @  topprt v
		|| No msg : msg
		end @ "\n" @ process' lib env ll
	|| (Com_bind b, ll) :
		case cbind env b in
		   Yes (ts,bs) :
			concmap prenv ts @ process' (mkprt ts @ extl lib bs) 
						    (ts @ env) ll
		|| No msg : msg @ "\n" @ process' lib env ll
		end
	|| (Com_msg s, ll) : s @ process' lib env ll
	|| (Com_msgnp s, ll) : s @ process lib env ll
	end
and process' lib env i = "> " @ process lib env i
in
CUNBUFF.CINTROFF."Welcome to interactive "@ (if Curry then "Haskell B." else "LML") @ " " @ version @ "!\n" @
case libs in
   No s : fail s
|| Yes lib : process' (mapfst mkids lib) [] input
end

