#include <stdio.h>
/*
** Bignum representation.
** BIGNUM -----> DVEK n bigit ...
**
**
** Dummy bignum routines.
*/

#if 0
struct vek {
    int **tag;
    int cnt;
    int vector[1];		/* really cnt elems */
};

struct bignum {
    int **tag;
    struct vek *vp;
};

extern int **mknode1();
extern struct vek *mknode();
extern int *DVEK[], *INT[], *PAIR1[], *TAG0[];

struct vek *
bigadd(x, y)
struct bignum *x, *y;
{
    struct vek *xv = x->vp, *yv = y->vp;
    struct vek *zv;

    zv = mknode(DVEK, 1, xv->vector[0] + yv->vector[0]);
    return zv;
}

struct vek *
bigsub(x, y)
struct bignum *x, *y;
{
    struct vek *xv = x->vp, *yv = y->vp;
    struct vek *zv;

    zv = mknode(DVEK, 1, xv->vector[0] - yv->vector[0]);
    return zv;
}

struct vek *
bigmul(x, y)
struct bignum *x, *y;
{
    struct vek *xv = x->vp, *yv = y->vp;
    struct vek *zv;

    zv = mknode(DVEK, 1, xv->vector[0] * yv->vector[0]);
    return zv;
}

struct vek *
bigdiv(x, y)
struct bignum *x, *y;
{
    struct vek *xv = x->vp, *yv = y->vp;
    struct vek *zv;

    zv = mknode(DVEK, 1, xv->vector[0] / yv->vector[0]);
    return zv;
}

struct vek *
bigmod(x, y)
struct bignum *x, *y;
{
    struct vek *xv = x->vp, *yv = y->vp;
    struct vek *zv;

    zv = mknode(DVEK, 1, xv->vector[0] % yv->vector[0]);
    return zv;
}

struct vek *
int2big(x)
int **x;
{
    struct vek *zv;

    zv = mknode(DVEK, 1, x[1]);
    return zv;
}

int
big2int(x)
struct bignum *x;
{
    struct vek *xv = x->vp;
    return xv->vector[0];
}

int **
big2intlist(x)
struct bignum *x;
{
    struct vek *xv = x->vp;
    return (int **)mknode(PAIR1, mknode1(INT, xv->vector[0]), mknode1(TAG0, 0));
}

int
bcmp(x, y)
struct bignum *x, *y;
{
    struct vek *xv = x->vp, *yv = y->vp;
    struct vek *zv;

    return xv->vector[0] > yv->vector[0] ? -1 : xv->vector[0] < yv->vector[0] ? 1 : 0;
}

void
printb(x)
struct bignum *x;
{
}

#else
#include "apm.h"

struct bignum {
    int **tag;
    APM vp;
};

extern int **mknode1();
extern int **mknode();
extern int *DVEK[], *INT[], *PAIR1[], *TAG0[];

#define SLOP 10

extern int **hp, **ehp, ***ep;

#define TSTGC2(x, y) do {\
    int size = (x->vp->alloclen + y->vp->alloclen)*2 + SLOP;\
    if (hp + size > ehp) {\
	*--ep = (int **)x;\
	*--ep = (int **)y;\
	gcstack(0);\
	y = (struct bignum *)*ep++;\
	x = (struct bignum *)*ep++;\
    }\
    if (hp + size > ehp)\
	noheapleft();\
    } while (0)

#define TSTGC1(x) do {\
    int size = x->vp->alloclen*2 + SLOP;\
    if (hp + size > ehp) {\
	*--ep = (int **)x;\
	gcstack(0);\
	x = (struct bignum *)*ep++;\
    }\
    if (hp + size > ehp)\
	noheapleft();\
    } while (0)

#define TSTGC(x, size) do {\
    if (hp + (size) > ehp) {\
	*--ep = (int **)x;\
	gcstack(0);\
	x = (struct bignum *)*ep++;\
    }\
    if (hp + (size) > ehp)\
	noheapleft();\
    } while (0)

APM
apm_alloc(n)
int n;
{
    APM r;
    int m;

    m = (sizeof(struct apm_struct) + (n-1)*sizeof(short) + sizeof(int *)-1) / sizeof(int *);
/* It's too dangerous to gc here!!!
    if (hp + m > ehp)
	gcstack(0);
*/
    r = (APM)hp;
    r->tag = (int)DVEK;
    r->alloclen = m - 2;
    hp += m;
    return r;
}

APM
bigadd(x, y)
struct bignum *x, *y;
{
    TSTGC2(x, y);
    return apm_add(x->vp, y->vp);
}

APM
bigsub(y, x)
struct bignum *x, *y;
{
    TSTGC2(x, y);
    return apm_sub(x->vp, y->vp);
}

APM
bigmul(x, y)
struct bignum *x, *y;
{
    TSTGC2(x, y);
    return apm_mul(x->vp, y->vp);
}

APM
bigdiv(y, x)
struct bignum *x, *y;
{
    APM z;
    TSTGC2(x, y);
    apm_div(&z, (APM)0, x->vp, y->vp);
    return z;
}

APM
bigmod(y, x)
struct bignum *x, *y;
{
    APM z, w;
    TSTGC2(x, y);
    apm_div(&z, &w, x->vp, y->vp);
    return w;
}

APM
int2big(x)
int **x;
{
    TSTGC(x, SLOP);
    return apm_from_int(x[1]);
}

int
big2int(x)
struct bignum *x;
{
    TSTGC1(x);
    return apm_to_int(x->vp);
}

int **
big2intlist(x)
struct bignum *x;
{
    APM xv;
    int i;
    int **p;
    int **r;

    TSTGC(x, x->vp->alloclen * 5 + SLOP);
    xv = x->vp;
    i = xv->alloclen;
    p = (int **)xv;
    r = mknode1(TAG0, 0);
    for(; i > 0; i--)
	r = mknode(PAIR1, mknode1(INT, p[i+1]), r);
    return r;
}

APM
bigneg(x)
struct bignum *x;
{
    TSTGC1(x);
    return apm_neg(x->vp);
}

int
bcmp(y, x)
struct bignum *x, *y;
{
    return apm_compare(x->vp, y->vp);
}

/* depends on BASE!!! */
void
fprintb(f, x)
FILE *f;
struct bignum *x;
{
    APM a = x->vp;
    int i;
    
    if (a->sign < 0)
	fprintf(f, "-");
    if (a->length == 0) {
	fprintf(f, "0");
    } else {
	fprintf(f, "%d", a->data[a->length-1]);
	for(i = a->length-2; i >= 0; i--)
	    fprintf(f, "%04d", a->data[i]);
    }
}

void
printb(x)
struct bignum *x;
{
    extern FILE *sf;
    fprintb(sf, x);
}

#endif
