module  P_Array ( Array, Assoc((:=)), array, listArray, (!), bounds, indices, 
		 elems, assocs, accumArray, (//), accum, amap, ixmap
	       ) where

-- The real stuff!
import LML_array
#define lmlarray {-:"Parray":-}
#define lmlindex {-:"Paindex":-}

--infixl 9  !
infix  5  :=
--infixl 4  //

data  Assoc a b =  a := b	deriving (Eq, Ord, Text)
data  (Ix a)    => Array a b = MkArray (a,a) (LML_array b) deriving ()

array		:: (Ix a) => (a,a) -> [Assoc a b] -> Array a b
listArray	:: (Ix a) => (a,a) -> [b] -> Array a b
(!)		:: (Ix a) => Array a b -> a -> b
bounds		:: (Ix a) => Array a b -> (a,a)
indices		:: (Ix a) => Array a b -> [a]
elems		:: (Ix a) => Array a b -> [b]
assocs		:: (Ix a) => Array a b -> [Assoc a b]
accumArray	:: (Ix a) => (b -> c -> b) -> b -> (a,a) -> [Assoc a c]
			     -> Array a b
(//)		:: (Ix a) => Array a b -> Assoc a b -> Array a b
accum		:: (Ix a) => (b -> c -> b) -> Array a b -> [Assoc a c]
			     -> Array a b
amap		:: (Ix a) => (b -> c) -> Array a b -> Array a c
ixmap		:: (Ix a, Ix b) => (a,a) -> (a -> b) -> Array b c
			     -> Array a c

array b@(l,u) ivs     = MkArray b (lmlarray 0 (index b u) getelem [(index b i, v) | i := v <- ivs])

getelem [v]           = v
getelem _             = error "Undefined array element"

listArray b vs        = array b (zipWith (:=) (range b) vs)

(MkArray b a) ! i     = lmlindex a (index b i)

bounds (MkArray b _)  = b

indices               = range . bounds

elems a               = [a!i | i <- indices a]

assocs a              = [i := a!i | i <- indices a]

a // iv@(i := v)      = array b (iv : [j := a!j | j <- range b, i /= j])
    	                where b = bounds a

accumArray f z b@(l,u) ivs  = MkArray b (lmlarray (index b l) (index b u) (foldl f z) [(index b i, v) | i := v <- ivs])

-- Very inefficient!
accum f               = foldl (\a (i := v)-> a // i := f (a!i) v)

amap f a              = array b [i := f (a!i) | i <- range b]
                        where b = bounds a

ixmap b f a           = array b [i := a ! f i | i <- range b]

instance  (Ix a, Eq b)  => Eq (Array a b)  where
    a == a'  	        =  assocs a == assocs a'

instance  (Ix a, Ord b) => Ord (Array a b)  where
    a <=  a'  	    	=  assocs a <=  assocs a'


instance  (Ix a, Text a, Text b) => Text (Array a b)  where
    showsPrec p a = showParen (p > 9) (
		    showString "array " .
		    shows (bounds a) . showChar ' ' .
		    shows (assocs a)                  )

    readsPrec p = readParen (p > 9)
	   (\r -> [(array b as, u) | ("array",s) <- [lex r],
				     (b,t)       <- reads s,
				     (as,u)      <- reads t   ]
		  ++
		  [(listArray b xs, u) | ("listArray",s) <- [lex r],
					 (b,t)           <- reads s,
					 (xs,u)          <- reads t ])

instance  (Ix a, Binary a, Binary b) => Binary (Array a b)  where
    showBin a r = {-:"PshowBin":-} a r
    readBin b = {-:"PreadBin":-} b
{-
    showBin a = showBin (bounds a) . showBin (elems a)

    readBin bin = (listArray b vs, bin'')
		 where (b,bin')   = readBin bin
		       (vs,bin'') = readBin bin'
-}