--
-- $Header: /ufs/usr.src/local/lml/src/expr/RCS/ttype.m,v 97.0 90/07/07 14:39:17 augustss Exp $
--
module -- ttype
#include "../funnos.h"
#include "../transform/misc.t"
#include "../transform/hexpr.t"
#include "../expr/types.t.t"
#include "../misc/flags.t"
#include "../misc/misc.t"
#include "id.t"
#include "id.t.t"
#include "ttype.t.t"
#include "constr.t.t"
#include <Option>

export prttype, Tint, Tbool, Tchar, Tlist, Tfloat, Tinteger, Trational,
        Tarr, Tvar, Tvar1, Tvar2, Typerec,
	Ttuple, tvars, getTvars, flattype, eqtype, tpart, tname, Tstring, gettinfo, cpart,
	lprttype, hprttype, synexpand, tsubst, synexpandall, clsname, prcdecl, pridecl, iclsname, ityname,
	xmkcontype, cdecl2type, idecl2type;
rec
    prttype t = if Curry then hprttype t else lprttype t
and lprttype (mktvar v) = lprtvar v
 || lprttype (mktcons i []) = oprid i
 || lprttype (mktcons i lt) =
	case idtostr i in
	    "P->" : "("@lprttype(hd lt)@"->"@lprttype(hd (tl lt))@")"
	||  "_#2" : "("@lprttype(hd lt)@" # "@lprttype(hd (tl lt))@")"
	||  _ : "(" @ oprid i @ concmap (\x." "@lprttype x) lt @ ")"
	end
 || lprttype (mkterror s) = "Error: "@s
 || lprttype (mktcontype ts t) = "("@mixmap lpras ts ", " @ ") => " @ lprttype t
and lpras (mkassert c v) = oprid c @ " " @ lprtvar v
||  lpras (mkaerror e) = "ERROR "@e
and lprtvar v = '*'.if v < 10 then [chr(ord 'a' + v)] else 't'.itos v
and Tint  = mktcons hiInt []
and Tbool = mktcons hiBool []
and Tchar = mktcons hiChar []
and Tlist t = mktcons hiList [t]
and Tfloat  = mktcons hiFloat []
and Tinteger  = mktcons hiInteger []
and Trational  = mktcons hiRational []
and Tarr t1 t2 = mktcons hiARROW [t1; t2]
and Tstring = mktcons hiString []
and Tvar n = mktvar n
and Tvar1 = mktvar 1
and Tvar2 = mktvar 2
and tvars n = for 1 n mktvar
and mktup n = mktcons (hituple n) (tvars n)
and tuples = map mktup (from 2)
and Ttuple n = select (n-1) tuples
#if 0
and Ttuple n = let s = ('_'.'#'.itos n) in
	       let rec t = mktcons (mkid (FTTUPLEBASE+n) 
			     s
			     (idi_type t n (mktinfo t 1 false false [dummycon n]) [] None)
			     (Orignames Vimported Nofixity ["_PreludeBuiltin"; s]))
		       (tvars n)
	       in t
#endif
and Typerec fv fc (mktvar n) = fv n
 || Typerec fv fc (mktcons c l) = fc c (map (Typerec fv fc) l)
 || Typerec fv fc t = fail ("Typerec:"@prttype t)
and getTvars (mktcontype _ t) = getTvars t			-- There must be no unused type vars in the assertion!
||  getTvars t = Typerec (\x.[x]) (\_.reduce union []) t
and flattype (mktcons (mkid _ _ (idi_type _ _ (mktinfo _ _ _ f _) _ _) _) []) = f
||  flattype _ = false
and dummycon n = mkcons (mkids "?") (for 0 (n-1) (\x.(Tvar x,false)))
and eqtype (mktvar n) (mktvar m) = n = m
||  eqtype (mktcons i1 ts1) (mktcons i2 ts2) = eqid i1 i2 & And (map2 eqtype ts1 ts2)
||  eqtype _ _ = false			-- !! There are more cases!
and tpart (mktcontype _ t) = t
||  tpart t = t
and cpart (mktcontype ts _) = ts
||  cpart _ = []
and tname t =
    case tpart t in
	mktcons i _ : i
    ||	mkterror _ : dummyid
    end

-- Print a Haskell type
and hprttype t = hpr false t
and hpr _ (mktvar v) = hprtvar v
||  hpr _ (mktcons i []) = oprid i
||  hpr np (mktcons i ts) =
    case idtostr i in
	"P->" : paren np (hpr true (hd ts) @ " -> " @ hpr false (hd (tl ts)))
    ||  "PList" : "["@hpr false (hd ts)@"]"
    ||  '_'.'#'._ : "("@mix (map (hpr false) ts) ", " @")"
    ||  _ : paren np (oprid i @ " " @mix (map (hpr true) ts) " ")
    end
||  hpr _ (mktcontype ts t) = "("@mixmap hpras ts ", " @ ") => " @ hpr false t
||  hpr _ (mkterror s) = "Error "@s
and hpras (mkassert c v) = oprid c @ " " @ hprtvar v
||  hpras (mkaerror e) = "ERROR "@e
and hprtvar v = if v < 26 then [chr (ord 'a' + v)] else 'a'.itos v
and paren true s = "("@s@")"
||  paren false s = s
and gettinfo (mkid _ _ (idi_type _ _ ti _ _) _) = ti
-- Expand top level type synonym.
and synexpand (mktcons (mkid _ _ (idi_syn src _ dst) _) ts) =
    let (mktcons _ vs) = tpart src in
    let al = map2 (\(mktvar n).\t.(n,t)) vs ts in
    tsubst al dst
||  synexpand t = t
and is_syn (mktcons (mkid _ _ (idi_syn _ _ _) _) _) = true
||  is_syn _ = false
-- Expand all type synonyms
and synexpandall t =
    case while is_syn synexpand t in
	mktvar _ : t
    ||  mktcons i ts : mktcons i (map synexpandall ts)
    end
and tsubst al (v as mktvar n) = assocdef n al v
||  tsubst al (mktcons i ts) = mktcons i (map (tsubst al) ts)
||  tsubst _ t = fail ("tsubst "@prttype t)

and clsname (mkcdecl _ (mkassert ci _)) = ci
and iclsname (mkidecl _ ci _ _) = ci
and ityname (mkidecl _ _ ti _) = ti
and prcdecl c = prttype (cdecl2type c)
and pridecl i = prttype (idecl2type i)
and cdecl2type (mkcdecl ks (mkassert ci v)) = xmkcontype ks (mktcons ci [mktvar v])
||  cdecl2type (mkcdecl _ (mkaerror s)) = mkterror s
and idecl2type (mkidecl ks ci ti vs) = xmkcontype ks (mktcons ci [mktcons ti (map mktvar vs)])
and xmkcontype [] t = t
||  xmkcontype k t = mktcontype k t
end
