--
-- $Header: /ufs/usr.src/local/lml/src/expr/RCS/read.m,v 97.0 90/07/07 14:39:13 augustss Exp $
--
module
#include "id.t.t"
#include "id.t"
#include "ttype.t.t"
#include "ttype.t"
#include "types.t.t"
#include "einfo.t.t"
#include "annot.t"
#include "impexp.t.t"
#include <Option>

export Read, readimpid, readexpr, readbinding, readimplist, readinterface;
rec
    skipspace (' '.l) = skipspace l
 || skipspace ('\t'.l) = skipspace l
 || skipspace ('\n'.l) = skipspace l
 || skipspace l = l

and readimplist l = readlist readimpid l

and
    readlist f ll =
	case skipspace ll in
	   'N'.l :
		(l, [])
	|| 'L'.l :
		let! (l1, h) = f l in
		let! (l2, t) = readlist f l1 in
		(l2, h.t)
	end
and
    readstring ll =
	case skipspace ll in
	   '#'.l : let! (a, b) = splitat '\t' l in (b, a)
	end
and
    readid ll =
	let! (l1, s) = readstring ll in
	(l1, mkids s)
and
    readop ll =
	let! (l1, i) = readstring ll in
	let! (l2, f) = readstring l1 in
	(l2, (i, f))
and
    readexpr ll =
	case skipspace ll in
	   'a'.l :
		let! (l1, e1) = readexpr l in
		let! (l2, e2) = readexpr l1 in
		(l2, mkap e1 e2)
	|| 'l'.l :
		let! (l1, i) = readexpr l in
		let! (l2, e) = readexpr l1 in 
		(l2, mklam i e)
	|| 'c'.l :
		let! (l1, e) = readexpr l in
		let! (l2, bl) = readlist readpbinding l1 in
		(l2, mkcase e bl)
	|| 'e'.l :
		let! (l1, b) = readbinding l in
		let! (l2, e) = readexpr l1 in
		(l2, mkletv b e) 
	|| 'i'.l :
		let! (l1, i) = readid l in
		(l1, mkident i) 
	|| 'm'.l :
		let! (l0, opl) = readlist readfix l in
		let! (l1, impl) = readlist readimpid l0 in
		let! (l2, idl) = readlist readid l1 in
		let! (l3, b) = readbinding l2 in
		(l3, mkmodule (mkids "_LML") opl impl (map mkexpid idl) b) 
	|| 'h'.l :
		let! (l0, modid) = readid l in
		let! (l1, expids) = readoption (readlist readexpid) l0 in
		let! (l2, imps) = readlist readimport l1 in
		let! (l3, fixes) = readlist readfix l2 in
		let! (l4, b) = readbinding l3 in
		(l4, mkhmodule modid expids imps fixes b)
	|| 'I'.l :
		let! (l1, s) = readstring l in
		(l1, mkconst (cint (stoi s))) 
	|| 'C'.l :
		let! (l1, s) = readstring l in
		(l1, mkconst (cchar (stochar s))
			where stochar l = chr (stoi l)) 
	|| 'S'.l :
		let! (l1, s) = readstring l in
		(l1, mkconst (cstring s)) 
	|| 'F'.l :
	        let! (l1, s) = readstring l in
		(l1, mkconst (cfloat s))
	|| 'J'.l :
	        let! (l1, s) = readstring l in
		(l1, mkconst (cinteger s))
	|| 'Q'.l :
	        let! (l1, s) = readstring l in
		(l1, mkconst (crational s))
	|| 's'.l :
		let! (l1, i) = readid l in
		let! (l2, e) = readexpr l1 in
		(l2, mkas i e) 
	|| 'o'.l :
		let! (l1,e1) = readexpr l in
		let! (l2,e2) = readexpr l1 in
		(l2, mkcondp e1 e2) 
	|| 'R'.l :
		let! (l1,e) = readexpr l in
		let! (l2,t) = readttype l1 in
		(l2, mkinfo (restr t) e) 
	|| '|'.l :
		let! (l1,e) = readexpr l in
		let! (l2,a) = readstring l1 in
		(l2, mkinfo (parse_annot a) e)
	|| '1'.l :
	        let! (l1,s) = readstring l in
		let! (l2,es) = readlist readexpr l1 in
		(l2, mklistf (stoi s) es)
	|| '2'.l :
		let! (l1,e) = readexpr l in
		let! (l2,qs) = readlist readqual l1 in
		(l2, mklistg e qs)
	|| 'Z'.l :
	        let! (l1, p) = readexpr l in
		(l1, mklazyp p)
	|| r : fail ("No match in readexpr on:"@r)
	end

and
    readexpid ll =
        case skipspace ll in
	    '3'.l :
		 let! (l1, i) = readid l in
		 (l1, mkexpid i)
	||  '4'.l :
		 let! (l1, i) = readid l in
		 (l1, mkexpidall i)
	||  '5'.l :
		 let! (l1, i) = readid l in
		 (l1, mkexpidmodall i)
	||  '6'.l :
		 let! (l1, i) = readid l in
		 let! (l2, is) = readlist readid l1 in
		 (l2, mkexpidsome i is)
        end

and
    readimport ll =
        case skipspace ll in
	    '7'.l :
		 let! (l1, id) = readid l in
		 let! (l2, imps) = readlist readimpid l1 in
		 let! (l3, fixs) = readlist readfix l2 in
		 let! (l4, ents) = readlist readimpid l3 in
		 let! (l5, (b, is)) = readimpspec l4 in
		 let! (l6, rens) = readlist readrename l5 in
		 (l6, mkimport id imps fixs ents b is rens)
	end

and
    readinterface ll =
        case skipspace ll in
	    '^'.l :
		 let! (l1, id) = readid l in
		 let! (l2, imps) = readlist readimpid l1 in
		 let! (l3, fixs) = readlist readfix l2 in
		 let! (l4, ents) = readlist readimpid l3 in
		 (l4, mkimport id imps fixs ents false [] [])
	end
and
    readfix ll = 
        case skipspace ll in
	    '0'.l :
		 let! (l1, ids) = readlist readid l in
		 let! (l2, ass) = readstring l1 in
		 let! (l3, prec) = readstring l2 in
		 (l3, mkfixid ids (select (ord (hd ass) - ord '0' +1) [Infix; InfixL; InfixR; FPrefix; FPostfix; (\x.Nonfix)] (stoi prec)))
	end
and
    readimpspec ll = 
        case skipspace ll in
	    '8'.l :
		 let! (l1, b) = readstring l in
		 let! (l2, is) = readlist readexpid l1 in
		 (l2, (b="1", is))
	end

and
    readoption f ll =
        case skipspace ll in
	    '`'.l :
		(l, None)
	||  '='.l :
		let! (l1, x) = f l in
		(l1, Some x)
	end
and
    readtinfo ll =
        case skipspace ll in
	    '`'.l :
		(l, (0, false))
	||  '<'.l :
		let! (l1, x) = readstring l in
		let! (l2, y) = readstring l1 in
		(l2, (stoi x, y="1"))
	end
and
    readrename ll = 
        case skipspace ll in
	    '9'.l :
		 let! (l1, src) = readid l in
		 let! (l2, dst) = readid l1 in
		 (l2, (src, dst))
	end

and
    readqual ll =
        case skipspace ll in
	    'g'.l :
		let! (l1, p) = readexpr l in
		let! (l2, e) = readexpr l1 in
		(l2, mkqgen p e)
	||  'f'.l :
		let! (l1, e) = readexpr l in
		(l1, mkqfilter e)
	end

and
    readbinding ll =
	case skipspace ll in
	   't'.l :
		let! (l1, t) = readttype l in
		let! (l2, al) = readlist readatype l1 in
		let! (l3, ds) = readoption (readlist readid) l2 in
		(l3, mkbtype t al ds) 
	|| 'p'.l :
		let! (l1, p) = readlist readpbinding l in
		(l1, mkbpat p) 
	|| 'A'.l :
		let! (l1, b1) = readbinding l in
		let! (l2, b2) = readbinding l1 in
		(l2, mkband b1 b2) 
	|| 'O'.l :
		let! (l1, b1) = readbinding l in
		let! (l2, b2) = readbinding l1 in
		(l2, mkblocal b1 b2) 
	|| 'r'.l :
		let! (l1, b) = readbinding l in
		(l1, mkbrec b) 
	|| 'z'.l :
	        let! (l1, t1) = readttype l in
		let! (l2, t2) = readttype l1 in
		(l2, mkbsyn t1 t2)
	|| ':'.l :
	        let! (l1, t) = readcdecl l in
		let! (l2, b) = readbinding l1 in
	        (l2, mkbclass t b)
	|| ';'.l :
	        (l, mkbnull)
	|| '\''.l :
	        let! (l1, ts) = readlist readttype l in
	        (l1, mkbdefault ts)
	|| '.'.l :
	        let! (l1, t) = readidecl l in
		let! (l2, b) = readbinding l1 in
	        (l2, mkbinstance t b None)
	|| '+'.l :
	        let! (l1, is) = readlist readid l in
		let! (l2, t) = readttype l1 in
	        (l2, mkbsign is t)
	end
and readcdecl l =
	        let! (l1, t) = readttype l in
                let! (mktcons ci [mktvar v]) = tpart t in
		(l1, mkcdecl (cpart t) (mkassert ci v))
and readidecl l =
	        let! (l1, t) = readttype l in
		let! (mktcons ci [mktcons ti tvs]) = tpart t in
		(l1, mkidecl (cpart t) ci ti (map gtv tvs))
and
    readttype ll = 
	case skipspace ll in
	   'T'.l :
		let! (l1, i) = readid l in
		let! (l2, t) = readlist readttype l1 in
		(l2, mktcons i t) 
	|| 'y'.l :
		let! (l1, s) = readstring l in
		(l1, mktvar (stoi s)) 
	|| 'C'.l :
		let! (l1, ts) = readlist readttype l in
		let! (l2, t) = readttype l1 in
		(l2, mktcontype (acconv ts) t)
	end
and

    readatype ll =
	case skipspace ll in
	   '1'.l :
		let! (l1, i) = readid l in
		let! (l2, t) = readlist readsttype l1 in
		(l2, mkcons i t) 
	end
and

    readsttype ll =
        case skipspace ll in
	   '!'.l :
	   	let! (l1, t) = readttype l in
		(l1, (t,true)) 
	|| l	 :
		let! (l1, t) = readttype l in
		(l1, (t,false)) 
	end
and
    readimpid ll =
	case skipspace ll in
	   'f'.l :
		let! (l1, i) = readid l in
		let! (l2, t) = readttype l1 in
		let! (l3, f) = readfinfo l2 in
		(l3, mkimpid i t f)
	|| 'Y'.l :
		let! (l1, t) = readttype l in
		let! (l2, ds) = readoption (readlist readid) l1 in
		let! (l3, nf) = readtinfo l2 in
		(l3, mkimptype t ds nf) 
	|| '@'.l :
		let! (l1, t) = readttype l in
		let! (l2, al) = readlist readatype l1 in
		let! (l3, ds) = readoption (readlist readid) l2 in
		(l3, mkimpeqtype t al ds)
	|| '{'.l :
	       let! (l1, i) = readid l in
	       let! (l2, exps) = readlist readexpid l1 in
	       let! (l3, rens) = readlist readrename l2 in
	       (l3, mkimpimport i exps rens)
        || '}'.l :
	       let! (l1, src) = readttype l in
	       let! (l2, dst) = readttype l1 in
	       (l2, mkimpsyn src dst)
	|| '['.l :
	       let! (l1, t) = readcdecl l in
	       let! (l2, b) = readbinding l1 in
	       (l2, mkimpclass t b)
        || ']'.l :
	       let! (l1, t) = readidecl l in
	       let! (l2, d) = readstring l1 in
	       (l2, mkimpinstance t (d = "1"))
	|| 'F'.l :
		let! (l1, is) = readlist readid l in
		let! (l2, t) = readttype l1 in
		let! (l3, f) = readfinfo l2 in
		(l3, mkimpids is t f)
	end

and
    readpbinding ll =
	case skipspace ll in
	   'd'.l :
		let! (l1, e1) = readexpr l in
		let! (l2, e2) = readexpr l1 in
		(l2, (e1, e2)) 
	end

and
    readfinfo ll =
	case skipspace ll in
	   '*'.l :
		let! (l1, _.s1) = readstring l in
		let! (l2, _.s2._) = readstring l1 in
		let! (l3, s3) = if hdishash l2 then readstring l2 else (l2, "-2") in
		(l3, finfo (length s1) (map f s1) (f s2) (stoi s3)
		where f 'T' = true
		   || f _ = false)
	|| _ :
		(ll, f_unk)
	end
and hdishash ('#'._) = true
||  hdishash _ = false

and readerrmap ll =
    let (l1, func) = readstring ll in
    let (l2, file) = readstring l1 in
    let (l3, line) = readstring l2 in
    (l3, (func, (file, stoi line)))
and acconv c = map (\(mktcons c [mktvar v]).mkassert c v) c
and gtv (mktvar v) = v

and Read l = 
    let (l1, e) = readexpr l in
    let (l2, errtab) = readlist readerrmap l1 in
    (e, errtab)
end
