module
export Gbasicop, Gbasicconstr, Glabel, Galloc, Gcode;
rec type Gbasicop =
	ADD + SUB + MUL + DIV + MOD + NEG +
	EQ + NE + LT + GT + LE + GE +
	CHR + ORD + TAG
and type Gbasicconstr = Gbint + Gbchar + Gbtag + Gbfloat + Gbinteger
and type Glabel = Label Int + Notalabel + Continue
and type Galloc = Aheap + Astack
and type Gcode =
	PUSH Int		+ -- offset from top of stack
	PUSHGLOBAL Id		+
	EVAL			+
	LABEL Glabel 		+
	JMP Glabel		+
	JFALSE Glabel		+
	JFUN Int		+ -- tailcall with n arguments
	CALLFUN Int		+ -- call with n arguments
	UNWIND			+ -- return via top node

	ALLOC Int		+ -- allocate n hole nodes, and push n ptrs
	BCONSTR Gbasicconstr	+ -- mkint, mkbool, mkchar
	MKAP			+ -- construct application
	MKAPL Int		+ -- construct application with n arguments
	MKAPLV Int		+ -- Make application vector
	UPDATE Int		+
	MOVE Int		+

	CONSTR ConstructorType Int Int	+
	CASE Int (List(Int#Int#Glabel)) Glabel +
	SPLIT (List Bool) Int Int + -- Push arguments of a constructor

	BASICOP Gbasicop	+ -- ADD, SUB etc
	BIGOP Gbasicop		+ -- EQ, NE, ...
	PUSHBASIC Int		+ -- push basic value onto basic value stack
	POP Int			+ -- pop n entries from the pointer stack
	GET			+ -- Get integer
	GETTAG			+ -- Get constructor tag
	GETMETHOD Int		+ -- Get entry in method vector

	FUNSTART Id Int		+ -- Function, and no of arguments
	FUNEND			+ -- Function end
	-- optimizations
	RET			+ -- Real return, skip unwind state
	JGLOBAL Int Id		+ -- Direct jump to a function
	CALLGLOBAL Int Id	+ -- Direct call to a function
	BUPDRET Gbasicconstr Int+ -- Return a basic value
	CUPDRET ConstructorType Int Int Int+ -- Return a constructor
	UPDRET Int		+	-- update & return

	JMETHOD Int Int		+ -- Method jump: arity and method number
	CALLMETHOD Int Int	+ -- Method call: arity and method number

	SFUNSTART Id Int	+ -- Beginning of stingy code
	TEVAL 			+ -- Tests if a value is evaluated
	SCALLFUN Int 		+ -- Calls stingy code with n arg. at SFUNSTART
	SCALLGLOBAL Int Id      + -- Direct stingy call to a function
	JTRUE Glabel  		+ 

	-- The CONSTR TYPE instruction is translated into 0, 1 or 2
	-- of the following variants of constr.
	CNIL Int		+	-- Nil constructor, nullary
	CPAIR Int		+	-- Pair constructor, binary
	CTAG Int		+	-- Tag constructor, unary
	CVEK Int		+	-- Vector constructor
	CBASIC Gbasicconstr Int	+	-- INT, BOOL, CHAR constant
	CSTRING (List Char) 	+	-- string constant
	CMVECTOR Id (List Id)	+	-- method vector

	-- The SPLIT instruction is translated into 0, 1 or 2
	-- of the following variants of split.	
	SPLITPAIR Bool Bool	+
	SPLITTAG		+
	SPLITVEK (List Bool) Int	+

	-- Memory alloc mode
	AMODE Galloc		+

	--
	SPARK				-- Start parallel eval
end
