-- $Header: /ufs/usr.src/local/lml/src/Expr/RCS/prexport.m,v 97.0 90/07/07 14:36:31 augustss Exp $
module -- prexport
-- Print the export list of a module.
-- The main program only gets its type printed.
-- Only ordinary identifiers (beginning with '_') gets printed, not
-- stuff produced with the -Z flag, nor constructor functions.
#include "Expr.t.t"
#include "../expr/types.t.t"
#include "../expr/ttype.t.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/ttype.t"
#include "../expr/einfo.t"
#include "../expr/tinfo.t"
#include "../misc/flags.t"
#include "../expr/impexp.t.t"
#include "../expr/impexp.t"
export prexport;
rec prexport (Emodule i [mkexpid (mkid _ "Pmain" (idi_var _ (Ohastype t _)) _)] _) =
	lprttype t @ "\n"
||  prexport (Emodule i exps _) =
                let is = map expid exps in
                concmap prfix (concmap ecollid is) @
		(concmap p is
		where p (i as (mkid _ _ (idi_var (var_global f) (Ohastype t _)) _)) =
		    if Fullname | hd (idtostr i) = '_' then
			"import "@oprid i@": "@lprttype t@prfinfo f@";\n"
		    else
			""
		  || p (i as (mkid _ _ (idi_var _ (Ohastype t _)) _)) =
		    if Fullname | hd (idtostr i) = '_' then
			"import "@oprid i@": "@lprttype t@";\n"
		    else
			""
		  ||  p (mkid _ _ (idi_type t _ ti _ _) _) =
		      let cs = get_cs_from_tinfo ti in
		      "import type "@lprttype t@" = "@mix (map (\(mkcons i ys).oprid i@concmap (\(t,b).' '.plprttype t@if b then "!" else "") ys) cs) " + " @ ";\n"
                  ||  p (mkid _ _ (idi_syn t1 _ t2) _) =
		      "import type "@lprttype t1@" == "@lprttype t2@";\n"
		  ||  p _ = "")

/*
and plprttype (t as mktvar _) = lprttype t
||  plprttype (t as mktcons _ []) = lprttype t
||  plprttype t = "("@lprttype t@")"
*/
and plprttype t = lprttype t
and ecollid (i as (mkid _ _ (idi_var _ _) _)) = [i]
||  ecollid (i as mkid _ _ (idi_type _ _ ti _ _) _) = i . map (\(mkcons i ys).i) (get_cs_from_tinfo ti)
||  ecollid _ = []
and prfix i =
    case id_fixity i in
	Infix  n   : "infixn  \""@pid i@"\";\n"
    ||  InfixL n   : "infix   \""@pid i@"\";\n"
    ||  InfixR n   : "infixr  \""@pid i@"\";\n"
    ||  FPrefix n  : "prefix  \""@pid i@"\";\n"
    ||  FPostfix n : "postfix \""@pid i@"\";\n"
    ||  Nonfix     : "nonfix  \""@pid i@"\";\n"
    ||  Nofixity : ""
    end
and pid i = concmap prc (tl (idtostr i))
and prc '\\' = "\\\\"
||  prc c = [c]
end
