module
--
-- $Header: /ufs/usr.src/local/lml/src/Expr/RCS/Eprint.m,v 97.0 90/07/07 14:36:17 augustss Exp $
--
-- prettyprinter
--
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t.t"
#include "../expr/einfo.t.t"
#include "../expr/types.t.t"
#include "../expr/einfo.t"
#include "../expr/id.t"
#include "../expr/ttype.t"
#include "../expr/constrfun.t"
#include "Expr.t.t"
#include "../transform/misc.t"
#include "../misc/misc.t"
#include "../misc/flags.t"
#include "../expr/impexp.t"

export pr;
rec
    pr e = (if Curry then hpr1 0 e else pr1 0 e) @ "\n"
where rec
    issimple (Evar _) = true
||  issimple (Econstr _ []) = true
||  issimple (Eidapl _ []) = true
||  issimple _ = false
and isinfix (InfixL _) = true
||  isinfix (InfixR _) = true
||  isinfix (Infix _) = true
||  isinfix _ = false
and ppr1 i e = if issimple e then pr1 i e else '(' . pr1 i e @ ")"
and nli i = '\n' . space(4*i)
and prdef i dl = 
	mix (map (\(ii, e). oprid ii @ " = " @ pr1 i e) dl) (nli i @ "and ")
and prc (c as Cconstr _ _ _ _ _) & (isstring c) = '"'.cname c@"\""
||  prc (Cconstr ('_'.name) _ _ _ _) = pn name
||  prc (Cconstr name _ _ _ _) = pn name
and pn (s as c._) = if isalpha c | isdigit c | c = '\'' then s else "("@s@")"
and parpr i arg =
    if issimple arg then
	pr1 i arg
    else
	"(" @ pr1 i arg @ ")"
and opr i =
    let s = tl (idtostr i) in
    if Curry & isalpha (hd s) then "`"@s@"`" else s
and
    pr1 i e =
	case e in
	   Emodule id exp def :
		nli i @ "module " @ oprid id @
		nli i @ "export " @ mix (map prexpid exp) ", " @ ";" @
		nli i @ prdef i (conc def) @
		nli i @ "end"
	|| Evar ii : oprid ii
	|| Econstr c el : prc c @ (concmap (\e.' '.hppr1 i e) el)
        || Eap (Eap (Evar id) a1) a2 & (isinfix (id_fixity id)) :
	        parpr i a1 @ " " @ opr id @ " " @ parpr i a2
	|| Eap f a :
		(prapchain e
		where rec
		    prapchain (Eap fun arg) = prapchain fun @ " " @ parpr i arg
		||  prapchain e = ppr1 i e)
	|| Elam ide exp :
		('\\' . oprid ide) @ ('.' . pr1 i exp)
	|| Elet false def exp :
		nli i @ "let " @ prdef (i+1) def @
		nli i @ "in" @ nli(i+1) @ pr1 (i+1) exp
	|| Elet true def exp :
		nli i @ "let rec " @ prdef (i+1) def @
		nli i @ "in" @ nli(i+1) @ pr1 (i+1) exp
	|| Ecase exp casel defe :
		(nli i @ "case " @ pr1 i exp @ " in" @
		nli (i+1) @ mix (map prcasel casel) (" ||" @ nli (i+1)) @
		" ||" @ nli (i+1) @ "_ : " @ pr1 (i+1) defe @
		nli i @ "end "
		where prcasel (c1, idl, ee) = prc c1 @ concmap (\i.' '.oprid i) idl @ " : " @ pr1 (i+1) ee)
	|| Efailmatch n : "DEFAULT_" @ itos n
	|| Eidapl ii l :
		if Debug then
			oprid ii @ "{" @ mix (map (pr1 i) l) "," @ "}"
		else
			oprid ii @ concmap (\e.' '.ppr1 i e) l
	|| Elamapl il e el :
		if Debug then
			"\\{" @ mix (map oprid il) "," @
			"} " @ pr1 i e @ " {" @ mix (map (pr1 i) el) "," @ "}"
		else
			"(\\" @ mix (map oprid il) " " @
			"." @ pr1 i e @ ")" @ concmap (\e.' '.ppr1 i e) el
	|| Einfo inf e : preinfo inf (pr1 i e)
	|| _ : fail ("pr. unknown node:\n")
	end
and hprdef i (ii, e) = oprid ii @ " = " @ hpr1 i e
and hppr1 i e = if issimple e then hpr1 i e else '(' . hpr1 i e @ ")"
and hparpr i arg =
    if issimple arg then
	hpr1 i arg
    else
	"(" @ hpr1 i arg @ ")"
and
    hpr1 i e =
	case e in
	   Emodule id exp def :
	        "module " @ oprid id @ "(" @ mix (map prexpid exp) ", " @ ")" @ " where {\n" @
		mix (map (hprdef 0) (conc def)) ";\n" @
		"\n}\n"
	|| Evar ii : oprid ii
	|| Econstr c el : 
	        case prc c in
		    'P'.'#'._ : "(" @ mixmap (hppr1 i) el ", " @ ")"
                || s : s @ (concmap (\e.' '.hppr1 i e) el)
		end
        || Eap (Eap (Evar id) a1) a2 & (isinfix (id_fixity id)) :
	        hparpr i a1 @ " " @ opr id @ " " @ hparpr i a2
	|| Eap f a :
		(prapchain e
		where rec
		    prapchain (Eap fun arg) = prapchain fun @ " " @ hparpr i arg
		||  prapchain e = hppr1 i e)
	|| Elam ide exp :
		('\\' . oprid ide) @ (" -> " @ hpr1 i exp)
	|| Elet _ def exp :
	        hpr1 i exp @ " where {" @ nli (i+1) @
		mix (map (hprdef (i+1)) def) (";"@nli (i+1)) @
		nli i @ "}" @ nli i
	|| Ecase exp casel defe :
		(nli i @ "case " @ hpr1 i exp @ " of {" @ nli i @ "  " @
		mix (map prcasel casel) (nli i @ "| ") @
		(if defe = Efailmatch 0 & ~Debug then
		    ""
		else
		    nli i @ "| _ -> "@hpr1 i defe) @
		nli i @ "}" @ nli i
		where prcasel (c1, idl, ee) = prc c1 @ concmap (\i.' '.oprid i) idl @ " -> " @ hpr1 (i+1) ee)
	|| Efailmatch n : "DEFAULT_" @ itos n
	|| Eidapl ii l :
		if Debug then
			oprid ii @ "{" @ mix (map (hpr1 i) l) "," @ "}"
		else
			oprid ii @ concmap (\e.' '.hppr1 i e) l
	|| Elamapl il e el :
		if Debug then
			"\\{" @ mix (map oprid il) "," @
			"} " @ hpr1 i e @ " {" @ mix (map (hpr1 i) el) "," @ "}"
		else
			"(\\" @ mix (map oprid il) " -> \\" @
			" -> " @ hpr1 i e @ ")" @ concmap (\e.' '.hppr1 i e) el
	|| Einfo (restr t) e : "("@hpr1 i e@")::"@prttype t
	|| Einfo (trestr t) e : "("@hpr1 i e@")::"@prttype t	-- really print this?
	|| Einfo inf e : preinfo inf (hpr1 i e)
	|| _ : fail ("pr. unknown node:\n")
	end
end
