module
export Tetris, rot, coord, startT, charof;
rec
(type Tetris =
	T1 +	T2a +	T2b +	T3a +	T3b +	T3c +	T3d +
	T4a +	T4b +	T4c +	T4d +	T5a +	T5b +	T6a +	T6b +
	T7a +	T7b +	T7c +	T7d)
and coord T1  = mk ["**";
		    "*+"]
||  coord T2a = mk ["*+**"]
||  coord T2b = mk ["*";
		    "+";
		    "*";
		    "*"]
||  coord T3a = mk ["*";
		    "+";
		    "**"]
||  coord T3b = mk ["  *";
		    "*+*"]
||  coord T3c = mk ["**";
		    " +";
		    " *"]
||  coord T3d = mk ["*+*";
		    "*  "]
||  coord T4a = mk [" *";
		    " +";
		    "**"]
||  coord T4b = mk ["*+*";
		    "  *"]
||  coord T4c = mk ["**";
		    "+ ";
		    "* "]
||  coord T4d = mk ["*  ";
		    "*+*"]
||  coord T5a = mk ["* ";
		    "*+";
		    " *"]
||  coord T5b = mk [" **";
		    "*+ "]
||  coord T6a = mk [" *";
		    "*+";
		    "* "]
||  coord T6b = mk ["** ";
		    " +*"]
||  coord T7a = mk [" * ";
		    "*+*"]
||  coord T7b = mk [" *";
		    "*+";
		    " *"]
||  coord T7c = mk ["*+*";
		    " * "]
||  coord T7d = mk ["* ";
		    "+*";
		    "* "]
and mk ss =
	let [(xh,yh,_)] = find (='+') ss
	in map (\(x,y,_).(x-xh, y-yh)) (find (\c.c='*' | c='+') ss)
and find p ss =
	(filter (\(x,y,c).p c) 
	        (conc (map2 (\s.\y. map2 (\c.\x.(x,y,c)) s (from 1))
			    ss (from 1))))
and rot T1  = T1
||  rot T2a = T2b
||  rot T2b = T2a
||  rot T3a = T3b
||  rot T3b = T3c
||  rot T3c = T3d
||  rot T3d = T3a
||  rot T4a = T4b
||  rot T4b = T4c
||  rot T4c = T4d
||  rot T4d = T4a
||  rot T5a = T5b
||  rot T5b = T5a
||  rot T6a = T6b
||  rot T6b = T6a
||  rot T7a = T7b
||  rot T7b = T7c
||  rot T7c = T7d
||  rot T7d = T7a
and startT = [T1; T2a; T3d; T4b; T5b; T6b; T7a]
and charof T1  = '#'
||  charof T2a = '@'
||  charof T2b = '@'
||  charof T3a = '$'
||  charof T3b = '$'
||  charof T3c = '$'
||  charof T3d = '$'
||  charof T4a = '%'
||  charof T4b = '%'
||  charof T4c = '%'
||  charof T4d = '%'
||  charof T5a = '&'
||  charof T5b = '&'
||  charof T6a = '+'
||  charof T6b = '+'
||  charof T7a = ';'
||  charof T7b = ';'
||  charof T7c = ';'
||  charof T7d = ';'
end
