#include "4014.h"
#include "4014.t"
#include "array.t"
let rec
	size_x = (stoi (hd argv))
and	size_y = (stoi (hd (tl argv)))
and	dx = SIZE_X / size_x
and	dy = SIZE_Y / size_y
and	wplot (x1,y1) (x2,y2) = 
	      plot [x1*dx;y1*dy;x2*dx;y2*dy]
and	Wabov (x,y) = plot [x*dx-dx/2;y*dy+dy/2;x*dx+dx/2;y*dy+dy/2]
and	Wunder (x,y) = plot [x*dx-dx/2;y*dy-dy/2;x*dx+dx/2;y*dy-dy/2]
and	Wleft (x,y) = plot [x*dx-dx/2;y*dy+dy/2;x*dx-dx/2;y*dy-dy/2]
and	Wright (x,y) = plot [x*dx+dx/2;y*dy-dy/2;x*dx+dx/2;y*dy+dy/2]
and	Up (x,y) = (x,y+1)
and	Down (x,y) = (x,y-1)
and	Left (x,y) = (x-1,y)
and	Right (x,y) = (x+1,y)
and	permdir (x,y) = map (\f.f (x,y)) (select (hd (randlist (x * y) 1 24))
			        (permutations [Up;Down;Left;Right]))
and	outside (0,$) = true
||	outside ($,0) = true
||	outside (x,y) = if (x >= size_x) | (y >= size_y) then true else false

and	been_here (x,y) arr =
		  if outside (x,y) then true
		  else arrindex (arrindex arr y) x

and	set_here (x,y) arr = 
		  arrupdate arr y (arrupdate (arrindex arr y) x true)

and	labelroom (x,y) label = plotstr (x*dx) (y*dy) (itos label)
and 	plottroom from cord arr =
		concmap (\(a,b). if (been_here (a cord) arr) & from ~= (a cord)  then b cord else [])
		        [(Up,Wabov);(Down,Wunder);(Left,Wleft);(Right,Wright)] 

and	mkroom from cord arr depth =
	       if (been_here cord arr) then ([],arr) 
	       else 
	           let rec (plt,ar) = 
		           reduce (doroom cord (depth+1))
				  ("",set_here cord arr) (permdir cord)
                   in (/* labelroom cord depth  @ */ plottroom from cord arr @ plt,ar)

and	doroom from depth cord (plot,arr) =
	       let rec (newpl,newarr) = mkroom from cord arr depth
	       in ((plot @ newpl), newarr)


in fst (mkroom (0,1) (1,1) (arrmake 0 size_x (arrmake 0 size_y false)) 1)

