module
#include "stream.t"
#include "gates.t"
export dflop, rsflop;
rec dflop P Cl Ck D =
	let rec a  = gnand3 P d  b
	and     b  = gnand3 a Cl Ck
	and     c  = gnand3 b Ck d
	and	d  = gnand3 c Cl D
	and	Q  = gnand3 P b  QI
	and	QI = gnand3 Q Cl c
	in (Q, QI)
and rsflop R S =
	let rec Q  = gnand R QI
	and     QI = gnand S Q
	in (Q, QI)
end
