module -- equ.m
#include "aux.t"
#include "dom.t"
#include "syn.t"
#include "std.t"
export D, E;
rec E (Var i) r = lookup i r
||  E (Ap e1 e2) r =
	case E e1 r in
	   Fun f : f (E e2 r)
	|| _ : Error
	end
||  E (Lam p e) r =
	Fun (\x.
		if M p x r = tt then
			E e (r oo B p x)
		else
			Error)
||  E (Case _ []) r = Error
||  E (Case e0 ((p,e).pes)) r =
	let v =E e0 r in
	case M p v r in
	   error : Error
	|| tt : E e (r oo B p v)
	|| ff : E (Case e0 pes) r
	end
||  E (Let d e) r = E e (r oo D d r)
and D (And d1 d2) r = D d1 r oo D d2 r
||  D (Local d1 d2) r = D d2 (r oo D d1 r)
||  D (Rec d) r = (r' where rec r' = D d (r oo r'))
||  D (Bind p e) r = (Bl p (M p e' r) e' where e' = E e r)
||  D (Type _ _ its) r =
	(map2 (\n.\(c,ts).(c,mfun n (length ts) [])) (from 0) its,
	 map2 (\n.\(c,ts).(c,Coninfo n (length ts))) (from 0) its)
and mfun n 0 l = Con n (reverse l)
||  mfun n m l = Fun (\x.mfun n (m-1) (x.l))
and M (Pcond p e) v r = M p v r && istrue (E e (r oo B p v))
||  M (Pas i p) v r = M p v r
||  M (Pvar i) v r = tt
||  M (Pwild) v r = tt
||  M (Pcon c ps) (Con n es) r =
	case lookupc c r in
	   Coninfo tn tm :
		if tn ~= n then ff
		else if tm=length ps & tm=length es then
			reduce (\(p,e).\a.M p e r && a) tt (combine(ps,es))
		else error
	|| Cunbound : error
	end
||  M (Pcon c ps) v r = error
and B p v = (B' p v, [])
and B' (Pcond p e) v = B' p v
||  B' (Pas i p) v = (i,v) . B' p v
||  B' (Pvar i) v = [(i,v)]
||  B' (Pwild) v = []
||  B' (Pcon _ ps) (Con _ es) = reduce (\(p,e).\r.B' p e @ r) [] (combine(ps, es))
and Bl p m v = (Bl' p m v, [])
and Bl' (Pcond p e) m v = Bl' p m v
||  Bl' (Pas i p) m v = (i,if m=tt then v else Error) . Bl' p m v
||  Bl' (Pvar i) m v = [(i,if m=tt then v else Error)]
||  Bl' (Pwild) m v = []
||  Bl' (Pcon _ ps) m (Con _ es) = reduce (\(p,e).\r.Bl' p m e @ r) [] (combine(ps, es))
end

