module
#include "fmatrix.t"
#include "stream.t"
#include "sfloatop.t"
export lap;

rec
    f0 = float 0
and f4 = float 4
and relax n A =
	mkmat n (\x.\y.
		if x = 1 | x = n | y = 1 | y = n then
			A[x,y]
		else
			(A[x-1,y] .+ A[x+1,y] .+ A[x,y-1] .+ A[x,y+1]) ./ f4)
and convp n A1 A2 d = mreduce n fmax (mmap n fabs (mmap2 n (.-) A1 A2)) .< d
and picktrue (false::vs) (_::xs) = picktrue vs xs
||  picktrue (true::_) (x::_) = x
and lap max bounds delta =
	let rec A1 = mmap2 max (::) (mkmat max bounds) A2
	and A2 = relax max A1 in
	let conv = convp max A1 A2 (let rec sd = delta::sd in sd) in
	mmap max (picktrue conv) A2
end
