module
#include "stream.t"
infix ".+";
infix ".-";
infix ".*";
infix "./";
infix ".<";
export .+, .-, .*, ./, .<, float, fabs, fmax;
rec float x = let rec xs = itof x :: xs in xs
and fabs' x = if x<itof 0 then FloatSub (itof 0) x else x
and fabs xs = smap fabs' xs
and fmax' x y = if x>y then x else y
and fmax xs ys = sop fmax' xs ys
and x .< y = sop (<) x y
and x .+ y = sop FloatAdd x y
and x .- y = sop FloatSub x y
and x .* y = sop FloatMul x y
and x ./ y = sop FloatDiv x y
end
