-- A program to work out the number of days from the begining of the year,
-- showing the use of the "OldForm" part of the form structure to correct
-- user errors. This program can't deal with leap years.
--
-- A.Dwelly 6.4.88

#include "textio.t"

let rec Date err frm l =  
    let rec (Out,OldForm,Input1,Rest) = Form frm (map stoi) l
    
    and NumberOfDays [d;m;y] = itos (Sum (head (m - 1) Days) + d)

    and Days = [31;28;31;30;31;30;31;31;30;31;30;31]

    and Valid [d;m;y] = (m > 0) & (m <= 12) & (d > 0) & (d <= select m Days)

    in Clear @
       (if err then MoveTo 25 5 @ "Invalid date, please re-enter" else "") @
       MoveTo 30 10 @ "Day" @
       MoveTo 30 12 @ "Month" @
       MoveTo 30 14 @ "Year" @
       Input1 @
       (if Valid Out then
           MoveTo 25 18 @ NumberOfDays Out @ " days since January the first\n"
	else Date true OldForm Rest)

and DateForm = [Formelem 50 10 [Number] "";
                Formelem 50 12 [Number] "";
	        Formelem 50 14 [Number] ""]

in [CCBREAK] @ Date false DateForm input

-- As well as the output, the feedback and the rest of the input, the
-- "Form" function returns the completed form (with a list of recognisers
-- and the input string in reverse order) so that if the user has entered
-- a field in error, the Form function can be called again with the
-- completed form, allowing the fields to be corrected. Try inputing an
-- invalid date.
