
-- stylenoodle.m
--
-- Started 10.2.89 By A.Dwelly (C) ECRC gmbh 1989
--
-- Contains the dialogues that deal specificaly with the style of the
-- noodle front end.

module

#include "ps.t"
#include "munout.t"
#include "munin.t"
#include "fonts.t"
#include "gdc.t"
#include "tree.t"
#include "style.t"
#include "stylemenu.t"

export OpenNoodleWindow;

rec OpenNoodleWindow (Cart sx sy) logosq =
    (Seq [OpenFixedWindow  (Cart sx sy) White;
	  OutlineCanvas 0 Child (20^(sy-logosq-20)) (0^0) 0 (100^100)
	  2 White (Rect (logosq^logosq));
	  SBitmap (Child o Child) (1^1) ((logosq-2)^(logosq-2))
	  "oak.im8"; 
	  SInMs Lft Dep (Child o Child)],
     WindowMenuRules)

and WindowMenuRules ((n,ds),s) l =
    [OCons 0 (IsMs Lft Dep (NodeNum (Child (Child ds)))) WindowMenu]

and WindowMenu = PopUpMenuAt Lft (Vert Helvetica 18) Root 3
		 ["Move" ~> MenuTest "Move";
		  "Top" ~> MenuTest "Top";
		  "Bottom" ~> MenuTest "Bottom"]

end
