-- muntest4.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- Rubik's cube demo

#include "ps.t"
#include "munout.t"
#include "munin.t"
#include "gdc.t"
#include "rubik.t"
#include "muntest4gr.t"

-------------------------
-- Dialogue definition --
-------------------------

let rec Cube = Seq [Initialise;Transform; Terminate]

and     Initialise = Seq [Send BoxAnimate; WaitForDepress; Open; InitDraw]

and     WaitForDepress = 
	   Cond (IsAllMs Lft Dep) NullDialogue (Join RejectInput WaitForDepress)

and     Open s (AllMs Lft Dep cn pos.t) =
	   DC (RevokeAllMs Lft Dep @ RevokeAnimate @ DrawBackground pos) s t

and     InitDraw = MapSend [DrawCube; DrawPanel]

and     Transform = ConfirmExitCase (IsMs Lft Dep Button1) [
			  IsMs Lft Dep Button3 ~> Do (Twist Invert) NewFaces;
			  IsMs Lft Dep Button2 ~> 
			     Confirm (Do Reset NewFaces) NullDialogue;
			  IsMs Lft Dep 50 ~> Do (Twist A1) NewFaces;
			  IsMs Lft Dep 51 ~> Do (Twist A2) NewFaces;
			  IsMs Lft Dep 52 ~> Do (Twist A3) NewFaces;
			  IsMs Lft Dep 53 ~> Do (Twist A4) NewFaces;
			  IsMs Lft Dep 54 ~> Do (Twist A5) NewFaces;
			  IsMs Lft Dep 55 ~> Do (Twist A6) NewFaces;
			  IsMs Lft Dep 56 ~> Do (Twist A7) NewFaces;
			  IsMs Lft Dep 57 ~> Do (Twist A8) NewFaces;
			  IsMs Lft Dep 58 ~> Do (Twist A9) NewFaces;
			  IsMs Mid Dep 50 ~> Do (Twist Z1) NewFaces;
			  IsMs Mid Dep 51 ~> Do (Twist Z2) NewFaces;
			  IsMs Mid Dep 52 ~> Do (Twist Z3) NewFaces;
			  IsMs Mid Dep 53 ~> Do (Twist Z4) NewFaces;
			  IsMs Mid Dep 54 ~> Do (Twist Z5) NewFaces;
			  IsMs Mid Dep 55 ~> Do (Twist Z6) NewFaces;
			  IsMs Mid Dep 56 ~> Do (Twist Z7) NewFaces;
			  IsMs Mid Dep 57 ~> Do (Twist Z8) NewFaces;
			  IsMs Mid Dep 58 ~> Do (Twist Z9) NewFaces
			 ]

and     Terminate = NullDialogue

and     ConfirmExitCase c d =
	   Seq [Until c (Case d); Confirm NullDialogue (ConfirmExitCase c d)]

and     Confirm dyes dno = Seq [Send DrawConfirm; WaitForYes dyes dno]

and     WaitForYes dyes dno = 
	     Cond (IsMs Lft Dep Yes) (Seq [Send KillConfirm; dyes])
	     (Cond (IsMs Lft Dep No) (Seq [Send KillConfirm; dno])
	     (Seq [RejectInput; WaitForYes dyes dno]))

and     NewFaces (old,new) (h.t) = DC (DrawChangedFaces 1 old new) (old,new) t

in Dialogue Cube (StartPos,StartPos) input
