-- muntest1.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- This tests the opening of canvases.

#include "ps.t"
#include "munout.t"
#include "munin.t"

let rec OpenRect = OpenOutlinePopCanvas 1 (200^200) (0^0) 0 (100^100) 4 
		   Screen White (Rect (300^200))

and     OpenNgon = OpenOutlinePopCanvas 2 (400^400) (0^0) 0 (100^100) 
		   4 Screen SkyBlue 
		   (Ngon [100^100; 300^200; 500^100; 0^100; 300^300])

and     OpenNCurve = OpenOutlinePopCanvas 3 (200^450) (0^0) 0 (100^100)
		     4 Screen Magenta
	             (NCurve [50^0; 200^200; 0^200; 150^0])

and     OpenCircle = OpenOutlinePopCanvas 4 (100^450) (0^0) 0 (100^100)
		     4 Screen Red (Circle 50)

and     OpenRRect = OpenOutlinePopCanvas 5 (300^600) (0^0) 0 (100^100)
		    4 Screen SeaGreen 
	            (RoundRect (200^100) 30)

and     OpenSegment = OpenOutlinePopCanvas 6 (300^600) (0^0) 0 (100^100)
		      4 Screen Goldenrod 
	              (Segment (250^100) 200 45 70)

and     OpenDiamond = OpenOutlinePopCanvas 7 (700^100) (0^0) 0 (100^100)
		      4 Screen Goldenrod 
	              (Diamond (0^0) 200 30)

and     Interact (Ms b a n crds . t) = ApMap (RevokeMs Lft Dep) [1;2;3;4;5;6]
||      Interact (h.t) = (ConsolePrint "Odd event detected\n") @ Interact t

and     ApMap f	[] = []
||      ApMap f (h.t) = f h @ ApMap f t

in LoadMunich @
   OpenRect @
   InMs Lft Dep 1 @
   OpenNgon @
   InMs Lft Dep 2 @
   OpenNCurve @
   InMs Lft Dep 3 @
   OpenCircle @
   InMs Lft Dep 4 @
   OpenRRect @
   InMs Lft Dep 5 @
   OpenSegment @
   InMs Lft Dep 6 @
   OpenDiamond @
   InMs Lft Dep 7 @
   Interact (Events input)
